@use(Botble\Theme\Supports\ThemeSupport)

<div class="shortcode-speakers shortcode-speakers-style-1 team-sperkers-section-area sp1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            @foreach($speakers as $speaker)
                <div class="col-lg-3 col-md-6">
                    <div class="our-team-boxarea">
                        <div class="team-widget-area">
                            <img src="{{ Theme::asset()->url('images/shapes/speaker-shape-1.png') }}" alt="" class="elements21" />
                            <img src="{{ Theme::asset()->url('images/shapes/speaker-shape-2.png') }}" alt="" class="elements22" />
                            <div class="img1">
                                {{ RvMedia::image($speaker->avatar, $speaker->name, attributes: ['class' => 'team-img4']) }}

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp
                                    <div class="share">
                                        <a href="#">
                                            <x-core::icon name="ti ti-share" style="--bb-icon-size: 0.5rem"/>
                                        </a>
                                    </div>
                                    <ul>
                                        @foreach($socials as $social)
                                            <li>
                                                <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}" href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <div class="space28"></div>
                        <div class="content-area">
                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                            <div class="space16"></div>
                            @if ($title = $speaker->getMetaData('title', true))
                                <p>{!! BaseHelper::clean($title) !!}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
