@use(Botble\Theme\Supports\ThemeSupport)

<div class="team5-section-area sp7 shortcode-speakers shortcode-speaker-style-5" @style($variablesStyle)>
    <img src="{{ Theme::asset()->url('images/shapes/elements33.png') }}" alt="" class="elements31" />
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="team2-header heading8 space-margin80 text-center">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, '') }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space32"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif

                </div>
            </div>
        </div>
        <div class="row">
            @foreach($speakers as $speaker)
                <div class="col-lg-3 col-md-6" data-aos="zoom-in"
                     data-aos-duration="{{ 900 + (($loop->index + 1) * 100) }}">
                    <div class="our-team-boxarea">
                        <div class="team-widget-area">
                            <div class="img1">
                                {{ RvMedia::image($speaker->avatar, $speaker->name, attributes: ['class' => 'team-img4']) }}

                                <img src="{{ Theme::asset()->url('images/shapes/elements16.png') }}" alt=""
                                     class="team-img8" />

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp
                                    <ul>
                                        @foreach($socials as $social)
                                            <li>
                                                <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}"
                                                   href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <div class="space28"></div>
                        <div class="content-area">
                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                            <div class="space16"></div>
                            @if ($title = $speaker->getMetaData('title', true))
                                <p>{!! BaseHelper::clean($title) !!}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
