@php
    $featuredSpeakers = $speakers[0];
    $speakers = $speakers->slice(1);
@endphp
<div class="team10-section-area sp3 shortcode-speaker-style-9" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="heading13 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            <img src="{{ url('/storage/homepage10/general/logo2.png') }}" alt="" />
                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space20"></div>
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4">
                <div class="team10-widget-boxarea">
                    <div class="img1 image-anime">
                        {{ RvMedia::image($featuredSpeakers->avatar, $featuredSpeakers->name, 'medium') }}
                    </div>
                    <div class="text-area">
                        <a href="{{ $featuredSpeakers->url }}">{{ $featuredSpeakers->name }}</a>
                        <div class="space16"></div>
                        <p>{{ $featuredSpeakers->designation }}</p>
                    </div>
                </div>
                <div class="space30"></div>
            </div>

            <div class="col-lg-8">
                <div class="row">
                    @foreach ($speakers as $speakers)
                        <div class="col-lg-4 col-md-6">
                            <div class="team10-widget-boxarea2">
                                <div class="img1 image-anime">
                                    {{ RvMedia::image($speakers->avatar, $speakers->name, 'medium') }}
                                </div>
                                <div class="text-area">
                                    <a href="{{ $speakers->url }}">{{ $speakers->name }}</a>
                                    <div class="space16"></div>
                                    <p>{{ $speakers->designation }}</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
