@php
    $eventMetaDisplay = json_decode(theme_option('event_list_widget_meta_display', []), true);
    $shouldDisplayDateTime = in_array('date_time', $eventMetaDisplay);
    $shouldDisplayOrganizerName = in_array('organizer_name', $eventMetaDisplay);
    $shouldDisplayOrganizerTitle = in_array('organizer_title', $eventMetaDisplay);
    $shouldDisplayOrganizerImage = in_array('organizer_image', $eventMetaDisplay);
    $shouldDisplayAddress = in_array('address', $eventMetaDisplay);
@endphp
<div
    class="tab-content"
    id="pills-tabContent"
>
    @foreach ($data as $key => $item)
        <div
            class="tab-pane fade {{ $key == 0 ? 'show active' : '' }}"
            id="pills-{{ $key }}"
            role="tabpanel"
            aria-labelledby="pills-{{ $key }}-tab"
            tabindex="{{$key}}"
        >
            <div class="event-widget-area">
                @foreach ($item['events'] as $key => $event)
                    @php
                        $organizer = $event->organizer;
                        $number = $key + 1;
                    @endphp
                    <div class="row">
                        <div class="col-lg-10 m-auto">
                            @if ($key % 2 == 0)
                                {!! Theme::partial(
                                    'event-booking.event-start',
                                    compact(
                                        'event',
                                        'organizer',
                                        'number',
                                        'shouldDisplayDateTime',
                                        'shouldDisplayOrganizerName',
                                        'shouldDisplayOrganizerTitle',
                                        'shouldDisplayOrganizerImage',
                                        'shouldDisplayAddress',
                                    ),
                                ) !!}
                            @else
                                {!! Theme::partial(
                                    'event-booking.event-end',
                                    compact(
                                        'event',
                                        'organizer',
                                        'number',
                                        'shouldDisplayDateTime',
                                        'shouldDisplayOrganizerName',
                                        'shouldDisplayOrganizerTitle',
                                        'shouldDisplayOrganizerImage',
                                        'shouldDisplayAddress',
                                    ),
                                ) !!}
                            @endif
                            @if (!$loop->last)
                                <div class="space48"></div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach

</div>
