<?php

namespace Theme\Eventify\Http\Controllers;

use Botble\Theme\Facades\Theme;
use Botble\Theme\Http\Controllers\PublicController;
use Theme\Eventify\Http\Requests\HomeSearchRequest;

class HomeSearchController extends PublicController
{
    public function getSearch(HomeSearchRequest $request){
        $model = apply_filters('get_home_search_type');

        $results = $model::where('name', 'like', '%' . $request->input('q') . '%')
            ->limit(5)
            ->get();

        if ($results->isEmpty()) {
            return $this
                ->httpResponse()
                ->setError()
                ->setData([]);
        }

        return $this
            ->httpResponse()
            ->setData(Theme::partial('searches.home', compact('results')));
    }
}
