<?php

namespace Theme\Eventify\Supports;

use Botble\Language\Facades\Language;

class ThemeHelper
{
    public static function isSupportSplitText(): bool
    {
        if (! is_plugin_active('language')) {
            return true;
        }

        $excludedLocales = [
            'zh',
            'ja',
            'th',
            'km',
            'lo',
            'ar',
        ];

        $currentLocal = Language::getCurrentLocale();

        foreach ($excludedLocales as $locale) {
            if (str_contains($currentLocal, $locale)) {
                return false;
            }
        }

        return true;
    }
}
