@if (is_plugin_active('payment'))
    <link
        rel="stylesheet"
        href="{{ asset('vendor/core/plugins/payment/css/payment.css') }}?v=1.0.3"
    >
    @php
        Theme::asset()->container('header')->usePath()->add('jquery', 'libraries/jquery.min.js');
        Theme::asset()->container('header')->add('payment-js', 'vendor/core/plugins/payment/js/payment.js');
    @endphp

    {!! apply_filters(PAYMENT_FILTER_HEADER_ASSETS, null) !!}
@endif
@php
    Theme::set('pageTitle', __('Booking'));
    $account = auth('account')->user();
@endphp

<div class="container mt-3 position-relative">
    <div class="row flex-column-reverse flex-md-row g-3">
        <div class="col-md-7 booking-form contact-inner-section">
            <div class="booking-information card p-4 contact4-boxarea mb-3 border-0">
                <form
                    action="{{ route('public.booking.checkout') }}"
                    class="payment-checkout-form"
                    method="POST"
                >
                    @csrf
                    <input
                        type="hidden"
                        name="token"
                        value="{{ $token }}"
                    >
                    <input
                        type="hidden"
                        name="amount"
                        value="{{ $total }}"
                    >
                    <input
                        type="hidden"
                        name="tax_amount"
                        value="{{ $taxAmount }}"
                    >
                    <input
                        type="hidden"
                        name="event_id"
                        value="{{ $event->getKey() }}"
                    >
                    <input
                        type="hidden"
                        name="number_slots"
                        value="{{ $numberSlots }}"
                    >
                    <input
                        type="hidden"
                        name="currency"
                        value="{{ strtoupper(get_application_currency()->title) }}"
                    >
                    <input
                        type="hidden"
                        name="currency_id"
                        value="{{ get_application_currency_id() }}"
                    >

                    <div class="row py-3">
                        <p class="text-anime-style-3 mb-3">{{ __('Your Information') }}</p>
                        <div class="row">
                            <div class="mb-3 col-lg-12 input-area position-relative">
                                <label
                                    for="name"
                                    class="form-label required"
                                >{{ __('Name') }}</label>
                                <input
                                    type="text"
                                    name="name"
                                    value="{{ old('name', $account) }}"
                                    class="form-control eventify-input-class"
                                    id="name"
                                >
                            </div>
                            <div class="mb-3 col-lg-6 input-area position-relative">
                                <label
                                    for="email"
                                    class="form-label required"
                                >{{ __('Email') }}</label>
                                <input
                                    type="email"
                                    value="{{ old('email', $account) }}"
                                    name="email"
                                    class="form-control eventify-input-class"
                                    id="email"
                                >
                            </div>
                            <div class="mb-3 col-lg-6 input-area position-relative">
                                <label
                                    for="phone"
                                    class="form-label"
                                >{{ __('Phone') }}</label>
                                <input
                                    type="text"
                                    name="phone"
                                    value="{{ old('phone', $account) }}"
                                    class="form-control eventify-input-class"
                                    id="phone"
                                >
                            </div>
                            <div class="mb-3 input-area position-relative">
                                <label
                                    for="note"
                                    class="form-label"
                                >{{ __('Note') }}</label>
                                <textarea
                                    class="form-control eventify-input-class"
                                    name="note"
                                    id="note"
                                    rows="2"
                                ></textarea>
                            </div>

                            @if (!$account || !$account->getKey())
                                <div class="create-account">
                                    <div class="row mb-3">
                                        <div class="form-group mb-20 custom-checkbox d-flex">
                                            <label
                                                class="form-label w-100 custom-checkbox input-focus mb-0"
                                                for="register-account"
                                            >
                                                <input
                                                    type="checkbox"
                                                    id="register-account"
                                                    name="register_account"
                                                    value="1"
                                                    class="d-none"
                                                >
                                                <span class="checkmark"></span>
                                                {{ __('Register an account with above information?') }}
                                            </label>
                                        </div>
                                    </div>
                                    <div class="row mb-3 d-none form-create-account-password">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3 input-area position-relative">
                                                <label
                                                    class="form-label"
                                                    for="password"
                                                >{{ __('Password') }}</label>
                                                <input
                                                    type="password"
                                                    name="password"
                                                    id="password"
                                                    class="form-control eventify-input-class"
                                                >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group 3 input-area position-relative">
                                                <label
                                                    class="form-label"
                                                    for="password_confirm"
                                                >{{ __('Password confirm') }}</label>
                                                <input
                                                    type="password"
                                                    name="password_confirm"
                                                    id="password_confirm"
                                                    class="form-control eventify-input-class"
                                                >
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>

                    @include(
                        \ArchiElite\EventsBooking\Facades\EventsBookingHelper::viewPath('includes.tickets-form'),
                        ['quantity' => $numberSlots]
                    )

                    <div class="col-lg-12 payment-form">
                        @if (is_plugin_active('payment') &&
                                ($defaultPaymentMethod = PaymentMethods::getDefaultMethod()) &&
                                get_payment_setting('status', $defaultPaymentMethod))
                            <div class="form-group mb-3">
                                <label
                                    class="form-label"
                                    for="requests"
                                >{{ __('Payment method') }}</label>
                                <ul class="list-group list_payment_method">
                                    {!! apply_filters(PAYMENT_FILTER_ADDITIONAL_PAYMENT_METHODS, null, [
                                        'amount' => $total,
                                        'currency' => strtoupper(get_application_currency()->title),
                                        'name' => $event->name,
                                        'selected' => PaymentMethods::getSelectedMethod(),
                                        'default' => $defaultPaymentMethod,
                                        'selecting' => PaymentMethods::getSelectingMethod(),
                                    ]) !!}

                                    {!! PaymentMethods::render() !!}
                                </ul>
                            </div>
                        @endif
                        {!! apply_filters('form_extra_fields_render', null) !!}

                        <div class="form-group mb-3 custom-checkbox d-flex">
                            <label
                                for="terms_conditions"
                                class="form-label required w-100 custom-checkbox"
                            >
                                <input
                                    class="d-none"
                                    type="checkbox"
                                    id="terms_conditions"
                                    name="terms_conditions"
                                    value="1"
                                    @if (old('terms_conditions') == 1) checked @endif
                                >
                                <span class="checkmark"></span>
                                <span class="label">
                                    @if ($terms = theme_option('term_and_privacy_policy_url'))
                                        {{ __('I agree to the') }} <a
                                            href="{{ $terms }}"
                                            target="_blank"
                                        >{{ __('Terms and Privacy Policy.') }}</a>
                                    @else
                                        {{ __('I agree to the Terms and Privacy Policy.') }}
                                    @endif
                                </span>
                            </label>
                        </div>
                        <div class="form-group mb-0">
                            <button
                                type="submit"
                                class="vl-btn1 border-0 payment-checkout-btn"
                                data-processing-text="{{ __('Processing. Please wait...') }}"
                                data-error-header="{{ __('Error') }}"
                            >{{ __('Checkout') }}</button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
        <div class="col-md-5">
            <div class="booking-information border-rds8 p-3">
                <div class="information row gap-3">
                    <div class="event-preview col-lg-4">
                        {{ RvMedia::image($event->image, $event->name) }}
                    </div>
                    <div class="col-lg-8">
                        <p class="mb-2">
                            {{ __('Event:') }} <strong> {{ $event->name }} </strong><br>
                        </p>

                        <p class="mb-2">
                            {{ __('Start date:') }} <strong> {{ $event->started_at->format('D, M d, Y') }}
                            </strong><br>
                        </p>

                        <p class="mb-2">
                            @if ($endedAt = $event->ended_at)
                                {{ __('End date:') }} <strong> {{ $endedAt->format('D, M d, Y') }} </strong><br>
                            @endif
                        </p>
                        <p class="mb-2">
                            @if ($address = $event->address)
                                {{ __('Address:') }} <strong> {{ $address }} </strong><br>
                            @endif
                        </p>
                    </div>
                </div>

                <div class="p-0 mt-2">
                    <p>{{ $event->short_description }}</p>
                </div>
                <hr class="border-dark-subtle my-4">

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        {{ __('Number of slots:') }}
                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong data-bb-value="subtotal_amount">{{ $numberSlots }}</strong>
                    </div>
                </div>

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        {{ __('Price:') }}
                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong>{{ render_price($subtotal) }}</strong>
                    </div>
                </div>

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        {{ __('Discount:') }}
                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong data-bb-value="discount_amount">{{ format_price($couponAmount) }}</strong>
                    </div>
                </div>

                @if ($tax)
                    <div class="row d-flex justify-content-between p-0 mb-3">
                        <div class="col-md-6">
                            {{ __('Tax: ') }} ({{ $tax->title }})
                        </div>
                        <div class="col-md-6 text-end">
                            <strong
                                class="fs-5"
                                data-bb-value="tax_amount"
                            >{{ format_price($taxAmount) }}</strong>
                        </div>
                    </div>
                @endif

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        {{ __('Total:') }}
                    </div>
                    <div class="col-md-6 text-end fs-4">
                        <strong data-bb-value="total_amount">{{ format_price($total) }}</strong>
                    </div>
                </div>
            </div>

            <div class="mt-4 position-relative overflow-visible">
                @include('plugins/events-booking::coupons.partials.form')
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('vendor/core/plugins/events-booking/js/checkout.js') }}"></script>

@if (is_plugin_active('payment'))
    {!! apply_filters(PAYMENT_FILTER_FOOTER_ASSETS, null) !!}

    @php
        Theme::asset()
            ->container('footer')
            ->add('js-validation', 'vendor/core/core/js-validation/js/js-validation.js', ['jquery'])
            ->writeContent(
                'checkout-validator',
                JsValidator::formRequest(ArchiElite\EventsBooking\Http\Requests\CheckoutRequest::class),
            );
    @endphp
@endif
