@php
    $title = theme_option('event_list_title');
    $currentPage = $events->currentPage();
    $perPage = $events->perPage();
    $eventMetaDisplay = json_decode(theme_option('event_list_meta_display', []), true);
    $shouldDisplayDateTime = in_array('date_time', $eventMetaDisplay);
    $shouldDisplayOrganizerName = in_array('organizer_name', $eventMetaDisplay);
    $shouldDisplayOrganizerTitle = in_array('organizer_title', $eventMetaDisplay);
    $shouldDisplayOrganizerImage = in_array('organizer_image', $eventMetaDisplay);
    $shouldDisplayAddress = in_array('address', $eventMetaDisplay);
@endphp

{!! apply_filters('ads_render', null, 'event_list_before', ['class' => 'mb-2']) !!}

<div class="event-team-area sp1 event-list">
    <div class="container">
        @if ($title)
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="heading2 text-center space-margin60">
                        <h2>{!! BaseHelper::clean($title) !!}</h2>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-lg-12 m-auto">
                <div class="event-widget-area">
                    @foreach ($events as $key => $event)
                        @php
                            $organizer = $event->organizer;
                            $number = ($currentPage - 1) * $perPage + $key + 1;
                        @endphp
                        <div class="row">
                            <div class="col-lg-10 m-auto">
                                @if ($key % 2 == 0)
                                    {!! Theme::partial(
                                        'event-booking.event-start',
                                        compact(
                                            'event',
                                            'organizer',
                                            'number',
                                            'shouldDisplayDateTime',
                                            'shouldDisplayOrganizerName',
                                            'shouldDisplayOrganizerTitle',
                                            'shouldDisplayOrganizerImage',
                                            'shouldDisplayAddress',
                                        ),
                                    ) !!}
                                @else
                                    {!! Theme::partial(
                                        'event-booking.event-end',
                                        compact(
                                            'event',
                                            'organizer',
                                            'number',
                                            'shouldDisplayDateTime',
                                            'shouldDisplayOrganizerName',
                                            'shouldDisplayOrganizerTitle',
                                            'shouldDisplayOrganizerImage',
                                            'shouldDisplayAddress',
                                        ),
                                    ) !!}
                                @endif
                                @if (!$loop->last)
                                    <div class="space48"></div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>

                @if ($events instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator && $events->total() > 0)
                    <div class="space60"></div>
                    {{ $events->withQueryString()->links(Theme::getThemeNamespace('partials.pagination')) }}
                @endif
            </div>

        </div>
    </div>
</div>

{!! apply_filters('ads_render', null, 'event_list_after', ['class' => 'mt-2']) !!}
