@php
    $quantity ??= 1;
@endphp

@for($i = 0; $i < $quantity; $i++)
    <div class="row py-3 ticket-form" data-bb-value="{{ $i }}">
        <div class="d-flex justify-content-between align-items-start flex-wrap">
            <p class="text-anime-style-3 mb-3">{{ __('Ticket :number', ['number' => $i + 1]) }}</p>
            <a href="#" class="pe-4 mb-3" data-bb-toggle="fill-in-information">
                {{ __('Fill from above contact information') }}
            </a>
        </div>

        <div class="row">
            <div class="mb-3 col-lg-12 input-area position-relative">
                <label for="name" class="form-label required">{{ __('Name') }}</label>
                <input type="text" name="tickets[{{ $i }}][name]" value="{{ old(sprintf('tickets.%s.name', $i)) }}" class="form-control" id="name_{{$i}}">
            </div>
            <div class="mb-3 col-lg-6 input-area position-relative">
                <label for="email" class="form-label required">{{ __('Email') }}</label>
                <input type="email" name="tickets[{{ $i }}][email]" value="{{ old(sprintf('tickets.%s.email', $i)) }}" class="form-control" id="email_{{$i}}">
            </div>
            <div class="mb-3 col-lg-6 input-area position-relative">
                <label for="phone" class="form-label">{{ __('Phone') }}</label>
                <input type="text" name="tickets[{{ $i }}][phone]" value="{{ old(sprintf('tickets.%s.phone', $i)) }}" class="form-control" id="phone_{{$i}}">
            </div>
            <div class="mb-3 col-lg-12 input-area position-relative">
                <label for="note" class="form-label">{{ __('Note') }}</label>
                <textarea class="form-control" name="tickets[{{ $i }}][note]"  id="note_{{$i}}" rows="2">{{ old(sprintf('tickets.%s.note', $i)) }}</textarea>
            </div>
        </div>
    </div>
@endfor
