@php
    Theme::set('pageTitle', __('Blog Details'));

    $socialLinks = json_decode(theme_option('social_links', []), true);
    $tags = $post->tags ?? [];
    $categories = $post->categories;

    if ($coverImage = $post->getMetaData('cover_image', true)) {
        Theme::set('breadcrumb_background_image', $coverImage);
    }
@endphp

{!! apply_filters('ads_render', null, 'post_before', ['class' => 'mb-2']) !!}

<div class="blog-details-section sp8">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="blog-deatils-content heading2">
                    @if ($image = $post->image)
                        <div class="img1">
                            {{ RvMedia::image($image, $post->name, 'medium') }}
                        </div>
                    @endif
                    <div class="space32"></div>
                    {!! Theme::partial('blogs.post-meta', [
                        'post' => $post,
                    ]) !!}

                    @if ($name = $post->name)
                        <div class="space18"></div>
                        <h2>{{ $name }}</h2>
                    @endif
                    @if ($description = $post->description)
                        <div class="space16"></div>
                        <p>{{ $description }}</p>
                    @endif

                    <div class="space48"></div>
                    @if ($content = $post->content)
                        <div class="ck-content">
                            {!! BaseHelper::clean($content) !!}
                        </div>
                    @endif

                    <div class="space32"></div>
                    <div class="tags-social-area">
                        <div class="tags">
                            <h4>{{ __('Tags:') }}</h4>
                            <ul>
                                @foreach ($tags as $tag)
                                    <li><a href="{{ $tag->url }}">#{{ $tag->name }}</a></li>
                                @endforeach
                            </ul>
                        </div>

                        @php
                            $socials = \Botble\Theme\Supports\ThemeSupport::getSocialSharingButtons(
                                $post->url,
                                $post->name,
                                RvMedia::getImageUrl($post->image),
                            );
                        @endphp
                        @if ($socials)
                            <div @class(['details-share'])>
                                <h6>{{ __('Share:') }}</h6>
                                @foreach ($socials as $social)
                                    <a
                                        target="_blank"
                                        href="{{ $social['url'] }}"
                                    >
                                        {!! $social['icon'] !!}
                                    </a>
                                @endforeach
                            </div>
                        @endif

                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="space30 d-lg-none d-block"></div>
                <div class="blog-auhtor-details">
                    {!! dynamic_sidebar('blog_sidebar') !!}
                </div>
            </div>
        </div>
    </div>
</div>

{!! apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $post) !!}

<div class="bloginner-section-area sp1">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 m-auto">
                <div class="heading2 text-center space-margin60">
                    <h2>{{ __('Read More Blogs') }}</h2>
                </div>
            </div>
        </div>

        {!! Theme::partial('blogs.related.index', compact('post')) !!}

    </div>
</div>

{!! apply_filters('ads_render', null, 'post_after', ['class' => 'mt-2']) !!}
