@php
    $bgColor = Arr::get($config, 'background_color');
    $bgImage = Arr::get($config, 'background_image')
        ? RvMedia::getImageUrl(Arr::get($config, 'background_image'))
        : null;

    $variablesStyle = [
        "--widget-background-color: $bgColor" => $bgColor,
        "--widget-background-image: url($bgImage)" => $bgImage,
    ];
@endphp

<div
    class="cta7-section-area widget-action-block"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="cta7-bg-area">
                    <div class="row">
                        <div class="col-lg-7 m-auto">
                            <div class="cta-heading text-center">
                                @if ($title = Arr::get($config, 'title'))
                                    <h2>{!! BaseHelper::clean($title) !!}</h2>
                                @endif

                                @if ($description = Arr::get($config, 'description'))
                                    <div class="space16"></div>
                                    <p>{!! BaseHelper::clean($description) !!}</p>
                                @endif

                                @if (($buttonLabel = Arr::get($config, 'button_label')) && ($buttonUrl = Arr::get($config, 'button_url')))
                                    <div class="space32"></div>
                                    <div class="btn-area1">
                                        <a
                                            href="{{ $buttonUrl }}"
                                            class="vl-btn7"
                                        >{!! BaseHelper::clean($buttonLabel) !!}<span><x-core::icon
                                                    name="ti ti-arrow-right" /></span></a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
