<?php

use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Blog\Models\Tag;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class BlogTagsWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Blog Tags'),
            'description' => __('Widget blog tags'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        $tags = Tag::query()->wherePublished()->pluck('name', 'id')->all();
        $tagIds = Arr::get($this->getConfig(), 'tag_ids');

        return
            WidgetForm::createFromArray($this->getConfig())
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'tag_ids',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(__('Choose tags'))
                    ->choices($tags)
                    ->selected($tagIds)
                    ->searchable()
                    ->multiple()
            );
    }

    protected function data(): array|Collection
    {
        $config = $this->getConfig();
        $title = Arr::get($config, 'title');
        $tagIds = Arr::get($config, 'tag_ids');

        if (! $tagIds) {
            return [];
        }

        $tags = Tag::query()
            ->select('id', 'name')
            ->with('slugable')
            ->wherePublished()
            ->whereIn('id', $tagIds)
            ->get();

        if (! $tags) {
            return [];
        }

        return compact('title', 'tags');
    }

    protected function requiredPlugins(): array
    {
        return ['blog'];
    }
}
