<?php

use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\TextField;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;

class ButtonWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Button'),
            'description' => __('Widget button'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        return
            WidgetForm::createFromArray($this->getConfig())
                ->add(
                    'label',
                    TextField::class,
                    TextFieldOption::make()
                        ->label(__('Label'))
                )
                ->add(
                    'url',
                    TextField::class,
                    TextFieldOption::make()
                        ->label(__('URL'))
                );
    }
}
