<?php

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Forms\FieldOptions\NumberFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class EventListWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Event List'),
            'description' => __('Widget event list'),
            'title' => __('Title'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        return WidgetForm::createFromArray($this->getConfig())
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'number_of_days',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(__('Number of days'))
            )
            ->add(
                'limit',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(__('Number of events'))
                    ->helperText(__('If this field was not filled then we will take all events of the days'))
            );
    }

    protected function data(): array|Collection
    {
        $config = $this->getConfig();
        $title = Arr::get($config, 'title');
        $numberOfDays = Arr::get($config, 'number_of_days');
        $limit = Arr::get($config, 'limit');
        $data = [];
        $startDate = new DateTime();

        foreach (range(0, $numberOfDays - 1) as $key) {
            $cloneDate = clone $startDate;
            $date = $cloneDate->modify("+$key days");
            $dateTitle = __('Day') . ' ' . $key + 1;
            $events = Event::query()
                ->where(function (Builder $query) use ($date) {
                    $query
                        ->whereDate('started_at', $date);
                })
                ->where('status', EventStatusEnum::APPROVED())
                ->when($limit, function (Builder $query) use ($limit) {
                    $query->limit($limit);
                })
                ->get();

            $meta = [
                'date' => $date->format('M d, Y'),
                'date_title' => $dateTitle,
                'events' => $events,
            ];

            $data[$key] = $meta;
        }

        return compact('title', 'data');
    }
}
