<?php
/*
 * Eventify Quick Check-in System
 * Standalone PHP event check-in system with QR code scanning
 * 
 * CONFIGURATION - Update these settings for your database
 */

// Database Configuration
// define('DB_HOST', 'localhost');
// define('DB_NAME', 'eventify_db');
// define('DB_USER', 'your_username');
// define('DB_PASS', 'your_password');


// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'u105110351_tickets');
define('DB_USER', 'u105110351_tickets');
define('DB_PASS', '6N@yu6g82nHLuLz');

// Security Configuration
// Security Configuration
define('CHECKIN_PASSWORD', 'event2024'); // Change this password for security
define('REQUIRE_HTTPS', true); // Set to false for local development

// Error reporting (set to 0 for production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

/**
 * Database Connection Class
 */
class Database {
    private $pdo;
    
    public function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $this->pdo = new PDO($dsn, DB_USER, DB_PASS, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ]);
        } catch (PDOException $e) {
            throw new Exception("Database connection failed: " . $e->getMessage());
        }
    }
    
    public function getConnection() {
        return $this->pdo;
    }
}

/**
 * Ticket Validation and Check-in Class
 */
class TicketManager {
    private $db;
    
    public function __construct($database) {
        $this->db = $database->getConnection();
    }
    
//     public function checkInTicket($ticketCode) {
//         try {
//             // First, validate the ticket exists and get details
//             // $stmt = $this->db->prepare("
//             //     SELECT t.*, e.name as event_name, e.date as event_date 
//             //     FROM eb_tickets t 
//             //     LEFT JOIN events e ON t.event_id = e.id 
//             //     WHERE t.ticket_code = ? OR t.id = ?
//             // ");
//             $stmt = $this->db->prepare("
//     SELECT t.*, e.name as event_name, e.started_at as event_date 
//     FROM eb_tickets t 
//     LEFT JOIN eb_events e ON t.event_id = e.id 
//     WHERE t.hash = ? OR t.id = ?
// ");
            
//             $stmt->execute([$ticketCode, $ticketCode]);
//             $ticket = $stmt->fetch();
            
//             if (!$ticket) {
//                 return [
//                     'success' => false,
//                     'message' => 'Invalid ticket code. Please verify the code and try again.',
//                     'type' => 'error'
//                 ];
//             }
            
//             // Check if ticket is already checked in
//             if ($ticket['checked_in_at']) {
//                 return [
//                     'success' => false,
//                     'message' => 'This ticket has already been checked in at ' . 
//                               date('M j, Y g:i A', strtotime($ticket['checked_in_at'])),
//                     'type' => 'warning',
//                     'ticket_info' => [
//                         'holder_name' => $ticket['holder_name'] ?? 'N/A',
//                         'event_name' => $ticket['event_name'] ?? 'N/A',
//                         'ticket_type' => $ticket['ticket_type'] ?? 'Standard'
//                     ]
//                 ];
//             }
            
//             // Update ticket as checked in
//             // $updateStmt = $this->db->prepare("
//             //     UPDATE eb_tickets 
//             //     SET checked_in_at = NOW(), 
//             //         status = 'checked_in' 
//             //     WHERE id = ?
//             // ");
   
//              $updateStmt = $this->db->prepare("
//             UPDATE eb_event_attendee 
//             SET checked_in_at = NOW()
//           WHERE hash = ? AND event_id = ? AND attendee_id = ?
// ");
            
            
//             $updateStmt->execute([$ticket['id']]);
            
//             return [
//                 'success' => true,
//                 'message' => 'Successfully checked in!',
//                 'type' => 'success',
//                 'ticket_info' => [
//                     'holder_name' => $ticket['holder_name'] ?? 'N/A',
//                     'event_name' => $ticket['event_name'] ?? 'N/A',
//                     'ticket_type' => $ticket['ticket_type'] ?? 'Standard',
//                     'checked_in_at' => date('M j, Y g:i A')
//                 ]
//             ];
            
//         } 
        
        
//         catch (Exception $e) {
//             return [
//                 'success' => false,
//                 'message' => 'Database error: ' . $e->getMessage(),
//                 'type' => 'error'
//             ];
//         }
//     }

 public function checkInTicket($ticketCode) {
    try {
        // First, validate the ticket exists and get details
        $stmt = $this->db->prepare("
            SELECT ea.*, e.name as event_name, e.started_at as event_date,
                   a.name as holder_name, a.email, a.phone
            FROM eb_event_attendee ea 
            LEFT JOIN eb_events e ON ea.event_id = e.id 
            LEFT JOIN eb_accounts a ON ea.attendee_id = a.id 
            WHERE ea.hash = ?
        ");
        $stmt->execute([$ticketCode]);
        $ticket = $stmt->fetch();
        
        if (!$ticket) {
            return [
                'success' => false,
                'message' => 'Invalid ticket code. Please verify the code and try again.',
                'type' => 'error'
            ];
        }
        
        // Check if ticket is already checked in
        if ($ticket['checked_in_at']) {
            return [
                'success' => false,
                'message' => 'This ticket has already been checked in at ' . 
                           date('M j, Y g:i A', strtotime($ticket['checked_in_at'])),
                'type' => 'warning',
                'ticket_info' => [
                    'holder_name' => $ticket['holder_name'] ?? 'N/A',
                    'event_name' => $ticket['event_name'] ?? 'N/A',
                    'ticket_type' => 'General Admission' // Default value since your DB doesn't have ticket types
                ]
            ];
        }
        
        // Update ticket as checked in
        $updateStmt = $this->db->prepare("
            UPDATE eb_event_attendee 
            SET checked_in_at = NOW()
            WHERE hash = ? AND event_id = ? AND attendee_id = ?
        ");
        $updateStmt->execute([$ticket['hash'], $ticket['event_id'], $ticket['attendee_id']]);
        
        return [
            'success' => true,
            'message' => 'Successfully checked in!',
            'type' => 'success',
            'ticket_info' => [
                'holder_name' => $ticket['holder_name'] ?? 'N/A',
                'event_name' => $ticket['event_name'] ?? 'N/A',
                'ticket_type' => 'General Admission',
                'checked_in_at' => date('M j, Y g:i A')
            ]
        ];
        
    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage(),
            'type' => 'error'
        ];
    }
}   
}

// Handle AJAX requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    // Verify password
    if (!isset($_POST['password']) || $_POST['password'] !== CHECKIN_PASSWORD) {
        echo json_encode([
            'success' => false,
            'message' => 'Invalid access password.',
            'type' => 'error'
        ]);
        exit;
    }
    
    if ($_POST['action'] === 'checkin' && isset($_POST['ticket_code'])) {
        try {
            $db = new Database();
            $ticketManager = new TicketManager($db);
            $result = $ticketManager->checkInTicket($_POST['ticket_code']);
            echo json_encode($result);
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => 'System error: ' . $e->getMessage(),
                'type' => 'error'
            ]);
        }
        exit;
    }
}

// Check HTTPS requirement
$isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Check-in System</title>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 500px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 14px;
        }
        
        .content {
            padding: 30px 20px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
            border-left: 4px solid;
        }
        
        .alert.success {
            background-color: #d4edda;
            color: #155724;
            border-left-color: #28a745;
        }
        
        .alert.error {
            background-color: #f8d7da;
            color: #721c24;
            border-left-color: #dc3545;
        }
        
        .alert.warning {
            background-color: #fff3cd;
            color: #856404;
            border-left-color: #ffc107;
        }
        
        .alert.info {
            background-color: #d1ecf1;
            color: #0c5460;
            border-left-color: #17a2b8;
        }
        
        .https-warning {
            background-color: #f8d7da;
            color: #721c24;
            border-left-color: #dc3545;
            margin-bottom: 20px;
        }
        
        .scanner-container {
            margin-bottom: 30px;
        }
        
        #reader {
            border-radius: 8px;
            overflow: hidden;
        }
        
        .manual-entry {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 2px dashed #e0e0e0;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .ticket-info {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
        }
        
        .ticket-info h4 {
            margin-bottom: 10px;
            color: #333;
        }
        
        .ticket-info p {
            margin: 5px 0;
            color: #666;
        }
        
        .status-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 8px;
        }
        
        .status-indicator.active {
            background-color: #28a745;
        }
        
        .status-indicator.inactive {
            background-color: #dc3545;
        }
        
        .camera-status {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
            color: #666;
        }
        
        .loading {
            text-align: center;
            padding: 20px;
        }
        
        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 0 auto 10px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @media (max-width: 480px) {
            .container {
                margin: 10px;
                border-radius: 10px;
            }
            
            .content {
                padding: 20px 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎟️ Event Check-in</h1>
            <p>Scan QR codes or enter ticket codes manually</p>
        </div>
        
        <div class="content">
            <?php if (REQUIRE_HTTPS && !$isHttps): ?>
            <div class="alert https-warning" style="display: block;">
                <strong>⚠️ HTTPS Required:</strong> Camera access requires a secure connection. Please access this page via HTTPS for QR code scanning to work properly.
            </div>
            <?php endif; ?>
            
            <div id="alert-container"></div>
            
            <div class="camera-status">
                <span class="status-indicator inactive" id="camera-status"></span>
                <span id="camera-text">Camera Inactive</span>
            </div>
            
            <div class="scanner-container">
                <div id="reader"></div>
            </div>
            
            <div class="manual-entry">
                <h3>Manual Entry</h3>
                <form id="manual-form">
                    <div class="form-group">
                        <label for="ticket-code">Ticket Code:</label>
                        <input type="text" id="ticket-code" name="ticket_code" placeholder="Enter ticket code manually" autocomplete="off">
                    </div>
                    
                    <div class="form-group">
                        <label for="password">Access Password:</label>
                        <input type="password" id="password" name="password" placeholder="Enter access password" required>
                    </div>
                    
                    <button type="submit" class="btn" id="checkin-btn">
                        Check In Ticket
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script>
        class CheckInSystem {
            constructor() {
                this.scanner = null;
                this.isScanning = false;
                this.password = '';
                this.init();
            }
            
            init() {
                this.initializeScanner();
                this.bindEvents();
            }
            
            bindEvents() {
                // Manual form submission
                document.getElementById('manual-form').addEventListener('submit', (e) => {
                    e.preventDefault();
                    this.handleManualEntry();
                });
                
                // Auto-focus on ticket code input
                document.getElementById('ticket-code').addEventListener('input', (e) => {
                    if (e.target.value.length > 0 && !this.password) {
                        document.getElementById('password').focus();
                    }
                });
            }
            
            initializeScanner() {
                if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
                    this.showAlert('Camera not supported on this device or browser.', 'error');
                    return;
                }
                
                try {
                    this.scanner = new Html5QrcodeScanner("reader", {
                        qrbox: {
                            width: 250,
                            height: 250,
                        },
                        fps: 20,
                        rememberLastUsedCamera: true,
                        showTorchButtonIfSupported: true
                    });
                    
                    this.scanner.render(
                        (decodedText) => this.onScanSuccess(decodedText),
                        (error) => this.onScanError(error)
                    );
                    
                    // Update camera status
                    this.updateCameraStatus(true);
                    
                } catch (error) {
                    console.error('Scanner initialization error:', error);
                    this.showAlert('Failed to initialize camera: ' + error.message, 'error');
                    this.updateCameraStatus(false);
                }
            }
            
            onScanSuccess(decodedText) {
                if (this.isScanning) return;
                
                this.isScanning = true;
                console.log('QR Code scanned:', decodedText);
                
                // Prompt for password if not already provided
                if (!this.password) {
                    this.password = prompt('Enter access password:');
                    if (!this.password) {
                        this.isScanning = false;
                        return;
                    }
                }
                
                this.processCheckin(decodedText, this.password);
            }
            
            onScanError(errorMessage) {
                // Don't spam error messages for scanning attempts
                if (errorMessage.includes('NotFoundException')) {
                    return;
                }
                console.warn('Scan error:', errorMessage);
            }
            
            handleManualEntry() {
                const ticketCode = document.getElementById('ticket-code').value.trim();
                const password = document.getElementById('password').value;
                
                if (!ticketCode) {
                    this.showAlert('Please enter a ticket code.', 'error');
                    return;
                }
                
                if (!password) {
                    this.showAlert('Please enter the access password.', 'error');
                    return;
                }
                
                this.processCheckin(ticketCode, password);
            }
            
            processCheckin(ticketCode, password) {
                const btn = document.getElementById('checkin-btn');
                btn.disabled = true;
                btn.innerHTML = '<div class="spinner"></div> Processing...';
                
                fetch('', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: new URLSearchParams({
                        action: 'checkin',
                        ticket_code: ticketCode,
                        password: password
                    })
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network error: ' + response.statusText);
                    }
                    return response.json();
                })
                .then(data => {
                    this.handleResponse(data);
                })
                .catch(error => {
                    console.error('Request error:', error);
                    this.showAlert('Network error: ' + error.message, 'error');
                })
                .finally(() => {
                    btn.disabled = false;
                    btn.innerHTML = 'Check In Ticket';
                    this.isScanning = false;
                    
                    // Clear manual entry
                    document.getElementById('ticket-code').value = '';
                });
            }
            
            handleResponse(data) {
                this.showAlert(data.message, data.type);
                
                if (data.ticket_info) {
                    this.showTicketInfo(data.ticket_info);
                }
                
                // Store password for subsequent scans
                if (data.success || data.type === 'warning') {
                    this.password = document.getElementById('password').value;
                }
            }
            
            showAlert(message, type) {
                const container = document.getElementById('alert-container');
                const alert = document.createElement('div');
                alert.className = `alert ${type}`;
                alert.innerHTML = message;
                alert.style.display = 'block';
                
                // Clear previous alerts
                container.innerHTML = '';
                container.appendChild(alert);
                
                // Auto-hide success messages
                if (type === 'success') {
                    setTimeout(() => {
                        alert.style.display = 'none';
                    }, 5000);
                }
            }
            
            showTicketInfo(ticketInfo) {
                const existingInfo = document.querySelector('.ticket-info');
                if (existingInfo) {
                    existingInfo.remove();
                }
                
                const infoDiv = document.createElement('div');
                infoDiv.className = 'ticket-info';
                infoDiv.innerHTML = `
                    <h4>Ticket Information</h4>
                    <p><strong>Holder:</strong> ${ticketInfo.holder_name}</p>
                    <p><strong>Event:</strong> ${ticketInfo.event_name}</p>
                    <p><strong>Type:</strong> ${ticketInfo.ticket_type}</p>
                    ${ticketInfo.checked_in_at ? `<p><strong>Checked in:</strong> ${ticketInfo.checked_in_at}</p>` : ''}
                `;
                
                const alertContainer = document.getElementById('alert-container');
                alertContainer.appendChild(infoDiv);
            }
            
            updateCameraStatus(isActive) {
                const indicator = document.getElementById('camera-status');
                const text = document.getElementById('camera-text');
                
                indicator.className = `status-indicator ${isActive ? 'active' : 'inactive'}`;
                text.textContent = isActive ? 'Camera Active' : 'Camera Inactive';
            }
        }
        
        // Initialize the system when page loads
        document.addEventListener('DOMContentLoaded', () => {
            new CheckInSystem();
        });
    </script>
</body>
</html>