<?php if(is_plugin_active('payment')): ?>
    <link
        rel="stylesheet"
        href="<?php echo e(asset('vendor/core/plugins/payment/css/payment.css')); ?>?v=1.0.3"
    >
    <?php
        Theme::asset()->container('header')->usePath()->add('jquery', 'libraries/jquery.min.js');
        Theme::asset()->container('header')->add('payment-js', 'vendor/core/plugins/payment/js/payment.js');
    ?>

    <?php echo apply_filters(PAYMENT_FILTER_HEADER_ASSETS, null); ?>

<?php endif; ?>
<?php
    Theme::set('pageTitle', __('Booking'));
    $account = auth('account')->user();
?>

<div class="container mt-3 position-relative">
    <div class="row flex-column-reverse flex-md-row g-3">
        <div class="col-md-7 booking-form contact-inner-section">
            <div class="booking-information card p-4 contact4-boxarea mb-3 border-0">
                <form
                    action="<?php echo e(route('public.booking.checkout')); ?>"
                    class="payment-checkout-form"
                    method="POST"
                >
                    <?php echo csrf_field(); ?>
                    <input
                        type="hidden"
                        name="token"
                        value="<?php echo e($token); ?>"
                    >
                    <input
                        type="hidden"
                        name="amount"
                        value="<?php echo e($total); ?>"
                    >
                    <input
                        type="hidden"
                        name="tax_amount"
                        value="<?php echo e($taxAmount); ?>"
                    >
                    <input
                        type="hidden"
                        name="event_id"
                        value="<?php echo e($event->getKey()); ?>"
                    >
                    <input
                        type="hidden"
                        name="number_slots"
                        value="<?php echo e($numberSlots); ?>"
                    >
                    <input
                        type="hidden"
                        name="currency"
                        value="<?php echo e(strtoupper(get_application_currency()->title)); ?>"
                    >
                    <input
                        type="hidden"
                        name="currency_id"
                        value="<?php echo e(get_application_currency_id()); ?>"
                    >

                    <div class="row py-3">
                        <p class="text-anime-style-3 mb-3"><?php echo e(__('Your Information')); ?></p>
                        <div class="row">
                            <div class="mb-3 col-lg-12 input-area position-relative">
                                <label
                                    for="name"
                                    class="form-label required"
                                ><?php echo e(__('Name')); ?></label>
                                <input
                                    type="text"
                                    name="name"
                                    value="<?php echo e(old('name', $account)); ?>"
                                    class="form-control eventify-input-class"
                                    id="name"
                                >
                            </div>
                            <div class="mb-3 col-lg-6 input-area position-relative">
                                <label
                                    for="email"
                                    class="form-label required"
                                ><?php echo e(__('Email')); ?></label>
                                <input
                                    type="email"
                                    value="<?php echo e(old('email', $account)); ?>"
                                    name="email"
                                    class="form-control eventify-input-class"
                                    id="email"
                                >
                            </div>
                            <div class="mb-3 col-lg-6 input-area position-relative">
                                <label
                                    for="phone"
                                    class="form-label"
                                ><?php echo e(__('Phone')); ?></label>
                                <input
                                    type="text"
                                    name="phone"
                                    value="<?php echo e(old('phone', $account)); ?>"
                                    class="form-control eventify-input-class"
                                    id="phone"
                                >
                            </div>
                            <div class="mb-3 input-area position-relative">
                                <label
                                    for="note"
                                    class="form-label"
                                ><?php echo e(__('Note')); ?></label>
                                <textarea
                                    class="form-control eventify-input-class"
                                    name="note"
                                    id="note"
                                    rows="2"
                                ></textarea>
                            </div>

                            <?php if(!$account || !$account->getKey()): ?>
                                <div class="create-account">
                                    <div class="row mb-3">
                                        <div class="form-group mb-20 custom-checkbox d-flex">
                                            <label
                                                class="form-label w-100 custom-checkbox input-focus mb-0"
                                                for="register-account"
                                            >
                                                <input
                                                    type="checkbox"
                                                    id="register-account"
                                                    name="register_account"
                                                    value="1"
                                                    class="d-none"
                                                >
                                                <span class="checkmark"></span>
                                                <?php echo e(__('Register an account with above information?')); ?>

                                            </label>
                                        </div>
                                    </div>
                                    <div class="row mb-3 d-none form-create-account-password">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3 input-area position-relative">
                                                <label
                                                    class="form-label"
                                                    for="password"
                                                ><?php echo e(__('Password')); ?></label>
                                                <input
                                                    type="password"
                                                    name="password"
                                                    id="password"
                                                    class="form-control eventify-input-class"
                                                >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group 3 input-area position-relative">
                                                <label
                                                    class="form-label"
                                                    for="password_confirm"
                                                ><?php echo e(__('Password confirm')); ?></label>
                                                <input
                                                    type="password"
                                                    name="password_confirm"
                                                    id="password_confirm"
                                                    class="form-control eventify-input-class"
                                                >
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php echo $__env->make(
                        \ArchiElite\EventsBooking\Facades\EventsBookingHelper::viewPath('includes.tickets-form'),
                        ['quantity' => $numberSlots]
                    , array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                    <div class="col-lg-12 payment-form">
                        <?php if(is_plugin_active('payment') &&
                                ($defaultPaymentMethod = PaymentMethods::getDefaultMethod()) &&
                                get_payment_setting('status', $defaultPaymentMethod)): ?>
                            <div class="form-group mb-3">
                                <label
                                    class="form-label"
                                    for="requests"
                                ><?php echo e(__('Payment method')); ?></label>
                                <ul class="list-group list_payment_method">
                                    <?php echo apply_filters(PAYMENT_FILTER_ADDITIONAL_PAYMENT_METHODS, null, [
                                        'amount' => $total,
                                        'currency' => strtoupper(get_application_currency()->title),
                                        'name' => $event->name,
                                        'selected' => PaymentMethods::getSelectedMethod(),
                                        'default' => $defaultPaymentMethod,
                                        'selecting' => PaymentMethods::getSelectingMethod(),
                                    ]); ?>


                                    <?php echo PaymentMethods::render(); ?>

                                </ul>
                            </div>
                        <?php endif; ?>
                        <?php echo apply_filters('form_extra_fields_render', null); ?>


                        <div class="form-group mb-3 custom-checkbox d-flex">
                            <label
                                for="terms_conditions"
                                class="form-label required w-100 custom-checkbox"
                            >
                                <input
                                    class="d-none"
                                    type="checkbox"
                                    id="terms_conditions"
                                    name="terms_conditions"
                                    value="1"
                                    <?php if(old('terms_conditions') == 1): ?> checked <?php endif; ?>
                                >
                                <span class="checkmark"></span>
                                <span class="label">
                                    <?php if($terms = theme_option('term_and_privacy_policy_url')): ?>
                                        <?php echo e(__('I agree to the')); ?> <a
                                            href="<?php echo e($terms); ?>"
                                            target="_blank"
                                        ><?php echo e(__('Terms and Privacy Policy.')); ?></a>
                                    <?php else: ?>
                                        <?php echo e(__('I agree to the Terms and Privacy Policy.')); ?>

                                    <?php endif; ?>
                                </span>
                            </label>
                        </div>
                        <div class="form-group mb-0">
                            <button
                                type="submit"
                                class="vl-btn1 border-0 payment-checkout-btn"
                                data-processing-text="<?php echo e(__('Processing. Please wait...')); ?>"
                                data-error-header="<?php echo e(__('Error')); ?>"
                            ><?php echo e(__('Checkout')); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
        <div class="col-md-5">
            <div class="booking-information border-rds8 p-3">
                <div class="information row gap-3">
                    <div class="event-preview col-lg-4">
                        <?php echo e(RvMedia::image($event->image, $event->name)); ?>

                    </div>
                    <div class="col-lg-8">
                        <p class="mb-2">
                            <?php echo e(__('Event:')); ?> <strong> <?php echo e($event->name); ?> </strong><br>
                        </p>

                        <p class="mb-2">
                            <?php echo e(__('Start date:')); ?> <strong> <?php echo e($event->started_at->format('D, M d, Y')); ?>

                            </strong><br>
                        </p>

                        <p class="mb-2">
                            <?php if($endedAt = $event->ended_at): ?>
                                <?php echo e(__('End date:')); ?> <strong> <?php echo e($endedAt->format('D, M d, Y')); ?> </strong><br>
                            <?php endif; ?>
                        </p>
                        <p class="mb-2">
                            <?php if($address = $event->address): ?>
                                <?php echo e(__('Address:')); ?> <strong> <?php echo e($address); ?> </strong><br>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>

                <div class="p-0 mt-2">
                    <p><?php echo e($event->short_description); ?></p>
                </div>
                <hr class="border-dark-subtle my-4">

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        <?php echo e(__('Number of slots:')); ?>

                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong data-bb-value="subtotal_amount"><?php echo e($numberSlots); ?></strong>
                    </div>
                </div>

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        <?php echo e(__('Price:')); ?>

                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong><?php echo e(render_price($subtotal)); ?></strong>
                    </div>
                </div>

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        <?php echo e(__('Discount:')); ?>

                    </div>
                    <div class="col-md-6 text-end fs-5">
                        <strong data-bb-value="discount_amount"><?php echo e(format_price($couponAmount)); ?></strong>
                    </div>
                </div>

                <?php if($tax): ?>
                    <div class="row d-flex justify-content-between p-0 mb-3">
                        <div class="col-md-6">
                            <?php echo e(__('Tax: ')); ?> (<?php echo e($tax->title); ?>)
                        </div>
                        <div class="col-md-6 text-end">
                            <strong
                                class="fs-5"
                                data-bb-value="tax_amount"
                            ><?php echo e(format_price($taxAmount)); ?></strong>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="row d-flex justify-content-between p-0 mb-3">
                    <div class="col-md-6">
                        <?php echo e(__('Total:')); ?>

                    </div>
                    <div class="col-md-6 text-end fs-4">
                        <strong data-bb-value="total_amount"><?php echo e(format_price($total)); ?></strong>
                    </div>
                </div>
            </div>

            <div class="mt-4 position-relative overflow-visible">
                <?php echo $__env->make('plugins/events-booking::coupons.partials.form', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('vendor/core/plugins/events-booking/js/checkout.js')); ?>"></script>

<?php if(is_plugin_active('payment')): ?>
    <?php echo apply_filters(PAYMENT_FILTER_FOOTER_ASSETS, null); ?>


    <?php
        Theme::asset()
            ->container('footer')
            ->add('js-validation', 'vendor/core/core/js-validation/js/js-validation.js', ['jquery'])
            ->writeContent(
                'checkout-validator',
                JsValidator::formRequest(ArchiElite\EventsBooking\Http\Requests\CheckoutRequest::class),
            );
    ?>
<?php endif; ?>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/events-booking/booking.blade.php ENDPATH**/ ?>