<?php
    $cards = Shortcode::fields()->getTabsData(['title', 'description', 'url', 'icon_image'], $shortcode);
?>
<div class="choose-section-area sp2 featured-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 m-auto">
                <div class="heading2 text-center space-margin60">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <h5><?php echo BaseHelper::clean($subtitle); ?></h5>
                        <div class="space18"></div>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <h2><?php echo BaseHelper::clean($title); ?></h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $url = Arr::get($card, 'url');
                ?>

                <?php if(! ($title = Arr::get($card, 'title'))) continue; ?>
                <div class="col-lg-4 col-md-6">
                    <div class="choose-widget-boxarea">
                        <?php if($iconImage = Arr::get($card, 'icon_image')): ?>
                            <div class="icons">
                                <?php echo e(RvMedia::image($iconImage, 'icon')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="space24"></div>
                        <div class="content-area">
                            <a href="<?php echo e($url); ?>"><?php echo BaseHelper::clean($title); ?></a>
                            <div class="space16"></div>

                            <?php if($description = Arr::get($card, 'description')): ?>
                                <p><?php echo BaseHelper::clean($description); ?></p>
                                <div class="space24"></div>
                            <?php endif; ?>

                            <?php if($url): ?>
                                <a href="<?php echo e($url); ?>" class="readmore"><?php echo e(__("Read More")); ?>

                                    <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-arrow-right'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/shortcodes/featured-block/styles/style-1.blade.php ENDPATH**/ ?>