<?php
    $organizer = $event->organizer;
    $eventMetaDisplay = json_decode(theme_option('event_detail_meta_display', []), true);
    $shouldDisplayDateTime = in_array('date_time', $eventMetaDisplay);
    $shouldDisplayOrganizerName = in_array('organizer_name', $eventMetaDisplay);
    $shouldDisplayOrganizerTitle = in_array('organizer_title', $eventMetaDisplay);
    $shouldDisplayOrganizerImage = in_array('organizer_image', $eventMetaDisplay);
    $shouldDisplayAddress = in_array('address', $eventMetaDisplay);
    $isFullSlots = $event->booked_seats >= $event->seats;
    $isClosedBooking = $event->booking_closed_at && \Carbon\Carbon::now()->greaterThan($event->booking_closed_at);
?>
<div class="shedule-listarea">
    <div class="card">
        <div class="head">
            <?php echo e(__('Event Information')); ?>

        </div>
        <ul style="border-radius: 0">
            <?php if($organizer = $event->organizer): ?>
                <li class="border-0">
                    <?php echo e(__('Organizer')); ?> : <span><?php echo e($organizer->name); ?></span>
                </li>
            <?php endif; ?>

            <?php if($address = $event->address): ?>
                <li class="border-0">
                    <?php echo e(__('Address')); ?> : <span><?php echo e($address); ?></span>
                </li>
            <?php endif; ?>

            <li class="border-0">
                <?php echo e(__('Start date')); ?> : <span><?php echo e($event->started_at); ?></span>
            </li>

            <?php if($endedAt = $event->ended_at): ?>
                <li class="border-0">
                    <?php echo e(__('End date')); ?> : <span><?php echo e($endedAt); ?></span>
                </li>
            <?php endif; ?>

            <?php if($bookingClosedAt = $event->booking_closed_at): ?>
                <li class="border-0">
                    <?php echo e(__('Booking closed date')); ?> : <span class="<?php echo \Illuminate\Support\Arr::toCssClasses(['text-danger' => $isClosedBooking]); ?>"><?php echo e($event->booking_closed_at); ?></span>
                </li>
            <?php endif; ?>

            <li class="border-0">
                <?php echo e(__('Price')); ?> : <span><?php echo e(__(':price / Ticket', ['price' => format_price($event->price)])); ?></span>
            </li>

            <li
                class="border-0"
                style="border: none"
            >
                <?php echo e(__('Slots')); ?> : <span><?php echo e($event->booked_seats); ?></span> /
                <span><?php echo e($event->seats); ?></span>

                <?php if($isFullSlots): ?>
                    <span>( <?php echo e(__('Full')); ?> )</span>
                <?php endif; ?>
            </li>
        </ul>
        <form
            action="<?php echo e(route('public.booking')); ?>"
            method="POST"
        >
            <?php echo csrf_field(); ?>

            <input
                type="hidden"
                name="event_id"
                value="<?php echo e($event->getkey()); ?>"
            >
            <div class="form-group mb-3">
                <label
                    class="form-label"
                    for="events-booking-number-slots"
                ><?php echo e(__('Number Slots')); ?></label>
                <input
                    id="events-booking-number-slots"
                    class="form-control"
                    type="number"
                    name="number_slots"
                    value="1"
                    <?php if($isFullSlots || $isClosedBooking): echo 'disabled'; endif; ?>
                >
            </div>

            <button
                type="submit"
                class="vl-btn1"
                <?php if($isFullSlots || $isClosedBooking): echo 'disabled'; endif; ?>
            >
                <?php echo e(__('Book Now')); ?>

            </button>
        </form>
    </div>

    <?php if($address = $event->address): ?>
        <div class="space30"></div>
        <div class="mapouter">
            <div class="gmap_canvas">
                <iframe
                    src="https://maps.google.com/maps?q=<?php echo e(addslashes($address)); ?>&t=&z=13&ie=UTF8&iwloc=&output=embed"
                    width="600"
                    height="450"
                    style="border: 0"
                    allowfullscreen=""
                    loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"
                ></iframe>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/event-booking/event-sidebar.blade.php ENDPATH**/ ?>