<?php
    $postMetaData = json_decode(theme_option('blog_post_detail_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
    $shouldDisplayReadingTime = in_array('reading_time', $postMetaData);
    $shouldDisplayCategory = in_array('category', $postMetaData);
?>
<ul class="post-detail-meta">
    <?php if(($publishedDate = $post->created_at) && $shouldDisplayDateTime): ?>
        <?php
            $formatDate = new DateTime($publishedDate);
        ?>
        <li>
            <span>
                <?php if(theme_option('author_icon_image', '')): ?>
                    <?php echo e(RvMedia::image(theme_option('calender_icon_image', ''))); ?>

                <?php endif; ?>
                <?php echo e($formatDate->format('d M Y')); ?> <span class="symbol-slash"> | </span>
            </span>
        </li>
    <?php endif; ?>
    <?php if(($author = $post->author) && $shouldDisplayAuthor): ?>
        <?php
            $fullName = $author->first_name . ' ' . $author->last_name;
        ?>
        <li>
            <a href="javascript:void(0)">
                <?php if(theme_option('author_icon_image', '')): ?>
                    <?php echo e(RvMedia::image(theme_option('author_icon_image', ''))); ?>

                <?php endif; ?>
                <?php echo e($fullName); ?>

                <span class="symbol-slash"> | </span>
            </a>
        </li>
    <?php endif; ?>
    <?php if(($views = $post->views) && $shouldDisplayView): ?>
        <li>
            <span>
                <?php if(theme_option('views_icon_image', '')): ?>
                    <?php echo e(RvMedia::image(theme_option('views_icon_image', ''))); ?>

                <?php endif; ?>
                <?php echo e($views); ?>

                <span class="symbol-slash"> | </span>
            </span>
        </li>
    <?php endif; ?>
    <?php if(($readingTime = $post->timeReading) && $readingTime > 0 && $shouldDisplayReadingTime): ?>
        <li>
            <span>
                <?php if(theme_option('reading_time_icon_image', '')): ?>
                    <?php echo e(RvMedia::image(theme_option('reading_time_icon_image', ''))); ?>

                <?php endif; ?>
                <?php echo e($readingTime == 1 ? __('1 minute read') : __(':count minutes read', ['count' => $readingTime])); ?>

                <span class="symbol-slash"> | </span>
            </span>
        </li>
    <?php endif; ?>
    <?php if(($categories = $post->categories) && $shouldDisplayCategory): ?>
        <li>
            <span>
                <?php if(theme_option('category_icon_image', '')): ?>
                    <?php echo e(RvMedia::image(theme_option('category_icon_image', ''))); ?>

                <?php endif; ?>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a
                        href="<?php echo e($category->url); ?>"
                        class="mx-0 px-0"
                        title="<?php echo e($category->name); ?>"
                    >
                        <?php echo e($category->name); ?>

                    </a>
                    <?php if(!$loop->last): ?>
                        ,
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </span>
        </li>
    <?php endif; ?>
</ul>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/blogs/post-meta.blade.php ENDPATH**/ ?>