<?php use \Botble\Theme\Supports\ThemeSupport; ?>

<?php
    Theme::set('pageTitle', $account->name);
?>

<?php echo apply_filters('ads_render', null, 'speaker_before', ['class' => 'mb-2']); ?>


<div class="team-details-section-area sp1">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="speakers-details-box">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="our-team-boxarea">
                                <div class="team-widget-area">
                                    <img
                                        src="<?php echo e(Theme::asset()->url('images/shapes/speaker-shape-1.png')); ?>"
                                        alt=""
                                        class="elements21"
                                    />
                                    <img
                                        src="<?php echo e(Theme::asset()->url('images/shapes/speaker-shape-2.png')); ?>"
                                        alt=""
                                        class="elements22"
                                    />
                                    <div class="img1">
                                        <?php echo e(RvMedia::image($account->avatar, $account->name, attributes: ['class' => 'team-img4'])); ?>

                                    </div>
                                </div>
                                <div class="content-area">
                                    <a href="<?php echo e($account->url); ?>"><?php echo e($account->name); ?></a>
                                    <?php if($title = $account->getMetaData('title', true)): ?>
                                        <div class="space16"></div>
                                        <p><?php echo BaseHelper::clean($title); ?></p>
                                    <?php endif; ?>

                                    <?php if($socials = $account->getMetaData('socials', true)): ?>
                                        <?php
                                            $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                        ?>
                                        <div class="space24"></div>
                                        <ul>
                                            <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a
                                                        class="icon<?php echo e($loop->index + 1); ?>"
                                                        title="<?php echo e($social->getName()); ?>"
                                                        href="<?php echo e($social->getUrl()); ?>"
                                                        target="_blank"
                                                    >
                                                        <?php echo $social->getIconHtml(); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="speakesr-details-content heading2">
                                <h2><?php echo e(__('Personal Information')); ?></h2>
                                <div class="space16"></div>
                                <?php if($description = $account->getMetaData('description', true)): ?>
                                    <p><?php echo BaseHelper::clean($description); ?></p>
                                <?php endif; ?>
                                <div class="space32"></div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="details-content">
                                            <?php if($dob = $account->dob): ?>
                                                <h4><?php echo e(__('Date Of Birth:')); ?></h4>
                                                <div class="space12"></div>
                                                <a href="#"><?php echo e($dob->format('F d, Y')); ?></a>
                                            <?php endif; ?>

                                            <?php if($phone = $account->phone): ?>
                                                <div class="space32"></div>
                                                <h4><?php echo e(__('Mobile Number:')); ?></h4>
                                                <div class="space12"></div>
                                                <a href="tel:<?php echo e($phone); ?>"><?php echo e($phone); ?></a>
                                            <?php endif; ?>

                                            <?php if($address = $account->getMetaData('address', true)): ?>
                                                <div class="space32"></div>
                                                <h4><?php echo e(__('Address:')); ?></h4>
                                                <div class="space12"></div>
                                                <a href="#"><?php echo BaseHelper::clean($address); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo apply_filters('ads_render', null, 'speaker_after', ['class' => 'mt-2']); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/events-booking/speaker.blade.php ENDPATH**/ ?>