<?php
    $announcementDisplayHtml = apply_filters('announcement_display_html');
    $headerWrapperClass = $headerWrapperClass ?? null;
    $bgColor = theme_option('header_top_background_color');
    $textColor = theme_option('header_top_text_color');
?>

<div
    class="<?php echo \Illuminate\Support\Arr::toCssClasses(['header-top menu-top-area', $headerWrapperClass]); ?>"
    style="<?php echo \Illuminate\Support\Arr::toCssStyles([
        "--header-top-background-color: $bgColor" => $bgColor,
        "--header-top-text-color: $textColor" => $textColor,
    ]) ?>"
>
    <div class="container">
        <div class="d-flex flex-row-reverse">
            <div class="top-menu-area w-100 align-items-center">
                <?php if($announcementDisplayHtml): ?>
                    <?php echo $announcementDisplayHtml; ?>

                <?php endif; ?>

                <?php echo dynamic_sidebar('header_top_sidebar'); ?>


                <div class="d-flex align-center">
                    <?php echo Theme::partial('header.items.language-switcher'); ?>

                    <?php echo Theme::partial('header.items.currency-switcher'); ?>

                </div>
                <div class="btn-area">
                    <?php echo Theme::partial('header.items.login'); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/header/header-top.blade.php ENDPATH**/ ?>