<?php
    $couponCode = \ArchiElite\EventsBooking\Facades\BookingHelper::getCheckoutData('coupon_code');
    $couponAmount = \ArchiElite\EventsBooking\Facades\BookingHelper::getCheckoutData('coupon_amount');
?>
<div class="order-detail-box mb-20" data-refresh-url="<?php echo e(route('coupon.refresh')); ?>">
    <button class="btn-link ps-0 text-decoration-none toggle-coupon-form" type="button"><?php echo e(trans('plugins/events-booking::coupon.toggle_coupon_form_text')); ?></button>

    <div class="card coupon-form mb-3" style="<?php echo \Illuminate\Support\Arr::toCssStyles(['display: none' => ! ($couponCode && $couponAmount)]) ?>">
        <div class="card-body">
            <?php if($couponCode && $couponAmount): ?>
                <div class="d-flex align-items-center justify-content-between alert alert-success mb-0 w-100">
                    <span><?php echo e(__('Coupon code: :code', ['code' => $couponCode])); ?></span>
                    <input name="coupon_hidden" type="hidden" value="<?php echo e(! empty($couponCode)); ?>" />

                    <button class="btn btn-link text-decoration-none remove-coupon-code" data-url="<?php echo e(route('coupon.remove')); ?>" type="button">
                        <i class="fa fa-trash"></i>
                        <?php echo e(__('Remove')); ?>

                    </button>
                </div>
            <?php else: ?>
                <div class="form-group">
                    <label for="coupon_code" class="form-label"><?php echo e(trans('plugins/events-booking::coupon.coupon_code')); ?></label>
                    <div class="input-group">
                        <input type="text" id="coupon_code" name="coupon_code" class="form-control" placeholder="<?php echo e(trans('plugins/events-booking::coupon.coupon_code_placeholder')); ?>" value="<?php echo e(BaseHelper::clean(old('coupon_code'))); ?>">
                        <button class="btn btn-primary apply-coupon-code" data-url="<?php echo e(route('coupon.apply')); ?>" type="button">
                            <?php echo e(trans('plugins/events-booking::coupon.apply_coupon_code')); ?>

                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/plugins/events-booking/resources/views/coupons/partials/form.blade.php ENDPATH**/ ?>