<?php
    $logo = $logo ?? theme_option('logo');
    if(!$logo){
        $logo = Theme::asset()->url('images/header-logo.png');
    }
    $height = theme_option('logo_height', 25);
    $attributes = [
        'style' => sprintf('height: %s', is_numeric($height) ? "{$height}px" : $height),
        'loading' => false,
    ];

    $wrapperClass ??= null;
?>

<?php if($logo): ?>
    <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['site-logo', $wrapperClass]); ?>">
        <?php
            $siteTitle = theme_option('site_title');
        ?>

        <a class="d-flex" href="<?php echo e(BaseHelper::getHomepageUrl()); ?>">
            <?php echo e(RvMedia::image($logo, $siteTitle, attributes: [...$attributes])); ?>

        </a>
    </div>
<?php endif; ?>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/header/items/logo.blade.php ENDPATH**/ ?>