<?php
    $quantity ??= 1;
?>

<?php for($i = 0; $i < $quantity; $i++): ?>
    <div class="row py-3 ticket-form" data-bb-value="<?php echo e($i); ?>">
        <div class="d-flex justify-content-between align-items-start flex-wrap">
            <p class="text-anime-style-3 mb-3"><?php echo e(__('Ticket :number', ['number' => $i + 1])); ?></p>
            <a href="#" class="pe-4 mb-3" data-bb-toggle="fill-in-information">
                <?php echo e(__('Fill from above contact information')); ?>

            </a>
        </div>

        <div class="row">
            <div class="mb-3 col-lg-12 input-area position-relative">
                <label for="name" class="form-label required"><?php echo e(__('Name')); ?></label>
                <input type="text" name="tickets[<?php echo e($i); ?>][name]" value="<?php echo e(old(sprintf('tickets.%s.name', $i))); ?>" class="form-control" id="name_<?php echo e($i); ?>">
            </div>
            <div class="mb-3 col-lg-6 input-area position-relative">
                <label for="email" class="form-label required"><?php echo e(__('Email')); ?></label>
                <input type="email" name="tickets[<?php echo e($i); ?>][email]" value="<?php echo e(old(sprintf('tickets.%s.email', $i))); ?>" class="form-control" id="email_<?php echo e($i); ?>">
            </div>
            <div class="mb-3 col-lg-6 input-area position-relative">
                <label for="phone" class="form-label"><?php echo e(__('Phone')); ?></label>
                <input type="text" name="tickets[<?php echo e($i); ?>][phone]" value="<?php echo e(old(sprintf('tickets.%s.phone', $i))); ?>" class="form-control" id="phone_<?php echo e($i); ?>">
            </div>
            <div class="mb-3 col-lg-12 input-area position-relative">
                <label for="note" class="form-label"><?php echo e(__('Note')); ?></label>
                <textarea class="form-control" name="tickets[<?php echo e($i); ?>][note]"  id="note_<?php echo e($i); ?>" rows="2"><?php echo e(old(sprintf('tickets.%s.note', $i))); ?></textarea>
            </div>
        </div>
    </div>
<?php endfor; ?>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/events-booking/includes/tickets-form.blade.php ENDPATH**/ ?>