<?php
    $durationPattern = [800, 1000, 1200];
    $aosDuration = $durationPattern[$key % count($durationPattern)];
    $postMetaData = json_decode(theme_option('blog_post_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
?>

<div
    class="col-lg-4 col-md-6 aos-init post-item"
    data-aos="zoom-in"
    data-aos-duration="<?php echo e($aosDuration); ?>"
>
    <div class="blog4-boxarea">
        <?php if($image = $post->image): ?>
            <div class="img1">
                <?php echo e(RvMedia::image($post->image, $post->name, 'medium-rectangle-vertical')); ?>

            </div>
        <?php endif; ?>
        <div class="content-area post-metadata">
            <ul>
                <?php if(($publishedDate = $post->created_at) && $shouldDisplayDateTime): ?>
                    <?php
                        $formatDate = new DateTime($publishedDate);
                    ?>
                    <li>
                        <span>
                            <?php if($calenderIcon = theme_option('calender_icon_image')): ?>
                                <?php echo e(RvMedia::image($calenderIcon, 'calender icon')); ?>

                            <?php endif; ?>
                            <?php echo e($formatDate->format('d M Y')); ?> <span class="symbol-slash"> | </span>
                        </span>
                    </li>
                <?php endif; ?>
                <?php if(($author = $post->author) && $shouldDisplayAuthor): ?>
                    <?php
                        $fullName = $author->first_name . ' ' . $author->last_name;
                    ?>
                    <li>
                        <a
                            aria-label="<?php echo e($fullName); ?>"
                            href="<?php echo e($author->url); ?>"
                        >
                            <?php if($authorIcon = theme_option('author_icon_image')): ?>
                                <?php echo e(RvMedia::image($authorIcon, 'author icon')); ?>

                            <?php endif; ?>
                            <?php echo BaseHelper::clean($fullName); ?>

                            <span class="symbol-slash"> | </span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(($views = $post->views) && $shouldDisplayView): ?>
                    <li>
                        <span>
                            <?php if($viewIcon = theme_option('views_icon_image')): ?>
                                <?php echo e(RvMedia::image($viewIcon, 'view icon')); ?>

                            <?php endif; ?>
                            <?php echo BaseHelper::clean($views); ?>

                            <span class="symbol-slash"> | </span>
                        </span>

                    </li>
                <?php endif; ?>
            </ul>
            <?php if($name = $post->name): ?>
                <div class="space20"></div>
                <a
                    aria-label="<?php echo e($name); ?>}"
                    class="truncate-2-custom"
                    title="<?php echo e($name); ?>"
                    href="<?php echo e($post->url); ?>"
                    title="<?php echo e($name); ?>"
                ><?php echo e($name); ?></a>
            <?php endif; ?>
            <div class="space24"></div>
            <a
                aria-label="<?php echo e($name); ?>}"
                href="<?php echo e($post->url); ?>"
                class="readmore"
            ><?php echo e(__('Read now')); ?>

                <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-arrow-right'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
            </a>
            <div class="arrow">
                <a
                    aria-label="<?php echo e($name); ?>}"
                    href="<?php echo e($post->url); ?>"
                ><?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-arrow-right'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?></a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/blogs/post.blade.php ENDPATH**/ ?>