<div class="shortcode-events-schedule shortcode-events-schedule-style-2 event3-section-area sp1"
    style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>"
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="event2-header heading12 text-center space-margin60">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <h5><?php echo BaseHelper::clean($subtitle); ?></h5>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3"><?php echo BaseHelper::clean($title); ?></h2>
                    <?php endif; ?>

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" data-aos="fade-up" data-aos-duration="1000">
                <?php if($tabs): ?>
                    <div class="tabs-button space-margin60">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item" role="presentation">
                                    <button
                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'active' => $loop->first]); ?>" data-bs-toggle="pill"
                                        id="pills-<?php echo e($item['date']); ?>-tab"
                                        data-bs-target="#pills-<?php echo e($item['date']); ?>"
                                        type="button" role="tab" aria-selected="true">
                                        <span class="calender"><img
                                                src="<?php echo e(Theme::asset()->url('images/icons/calender.svg')); ?>"
                                                alt="icon" /></span>

                                        <span class="pl-8">
											<span
                                                class="day"><?php echo e(__('Day :number', ['number' => $loop->index + 1])); ?></span>
											<span
                                                class="date"><?php echo e(Arr::get($item, 'month')); ?> <?php echo e(Arr::get($item, 'day')); ?>, <?php echo e(Arr::get($item, 'year')); ?></span>
										</span>
                                    </button>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="tab-content" id="pills-tabContent">
                    <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['tab-pane fade', 'show active' => $loop->first]); ?>" role="tabpanel"
                             id="pills-<?php echo e($tab['date']); ?>"
                             aria-labelledby="pills-<?php echo e($tab['date']); ?>-tab" tabindex="0">
                            <div class="event-widget-area">
                                <?php
                                    $events->loadMissing('speakers');
                                ?>

                                <?php $__currentLoopData = $tab['events']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $speakers = $event->speakers->take(2);
                                    ?>

                                    <div class="row"
                                         data-bb-value="events-schedule"
                                         data-date="<?php echo e($event->started_at->format('Y-m-d')); ?>"
                                    >
                                        <div class="col-lg-1"></div>
                                        <div class="col-lg-10 m-auto">
                                            <div class="event2-boxarea box1">
                                                <h1 class="ordinal-number"><?php echo e($loop->index + 1); ?></h1>
                                                <div class="row align-items-center">
                                                    <?php if($loop->even): ?>
                                                        <div class="col-lg-5">
                                                            <div class="img1">
                                                                <?php echo e(RvMedia::image($event->image, $event->name, 'small-rectangle')); ?>

                                                            </div>
                                                        </div>
                                                        <div class="col-lg-1"></div>
                                                        <div class="col-lg-6">
                                                            <div class="content-area">
                                                                <ul>
                                                                    <li>
                                                                        <a href="<?php echo e($event->url); ?>"><img
                                                                                src="<?php echo e(Theme::asset()->url('images/icons/clock.svg')); ?>"
                                                                                alt="" /><?php echo e($event->started_at->format('H:i')); ?>

                                                                            <?php echo e($event->ended_at ? ' - ' . $event->ended_at->format('H:i') : ' - ∞'); ?>

                                                                            <span> | </span></a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="<?php echo e($event->url); ?>"><img
                                                                                src="<?php echo e(Theme::asset()->url('images/icons/location.svg')); ?>"
                                                                                alt="" /><?php echo e($event->address); ?></a>
                                                                    </li>
                                                                </ul>
                                                                <div class="space20"></div>
                                                                <a href="<?php echo e($event->url); ?>"
                                                                   class="head"><?php echo e($event->name); ?></a>
                                                                <?php if($speakers->isNotEmpty()): ?>
                                                                    <div class="space24"></div>
                                                                    <div class="author-area">
                                                                        <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="autho-name-area">
                                                                                <div class="img1">
                                                                                    <?php echo e(RvMedia::image($speaker->avatar, $speaker->name, 'thumb')); ?>

                                                                                </div>
                                                                                <div class="text">
                                                                                    <a href="<?php echo e($speaker->url); ?>"><?php echo e($speaker->name); ?></a>
                                                                                    <?php if($speakerTitle = $speaker->getMetaData('title', true)): ?>
                                                                                        <div class="space8"></div>
                                                                                        <p><?php echo BaseHelper::clean($speakerTitle); ?></p>
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                    <div class="space24"></div>
                                                                <?php endif; ?>
                                                                <div class="btn-area1">
                                                                    <a href="<?php echo e($event->url); ?>" class="vl-btn9"
                                                                    ><span class="demo text-white"><?php echo e(__('purchase ticket now')); ?></span></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="col-lg-6">
                                                            <div style="max-width: 90% !important;"
                                                                 class="content-area">
                                                                <ul>
                                                                    <li>
                                                                        <a href="<?php echo e($event->url); ?>"><img
                                                                                src="<?php echo e(Theme::asset()->url('images/icons/clock.svg')); ?>"
                                                                                alt=""/><?php echo e($event->started_at->format('H:i')); ?>

                                                                            - <?php echo e($event->ended_at ? $event->ended_at->format('H:i') : '∞'); ?>

                                                                            <span> | </span></a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="<?php echo e($event->url); ?>"><img
                                                                                src="<?php echo e(Theme::asset()->url('images/icons/location.svg')); ?>"
                                                                                alt="" /><?php echo e($event->address); ?></a>
                                                                    </li>
                                                                </ul>
                                                                <div class="space20"></div>
                                                                <a href="<?php echo e($event->url); ?>"
                                                                   class="head"><?php echo e($event->name); ?></a>
                                                                <?php if($speakers->isNotEmpty()): ?>
                                                                    <div class="space24"></div>
                                                                    <div class="author-area">
                                                                        <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="autho-name-area">
                                                                                <div class="img1">
                                                                                    <?php echo e(RvMedia::image($speaker->avatar, $speaker->name, 'thumb')); ?>

                                                                                </div>
                                                                                <div class="text">
                                                                                    <a href="<?php echo e($speaker->url); ?>"><?php echo e($speaker->name); ?></a>
                                                                                    <?php if($speakerTitle = $speaker->getMetaData('title', true)): ?>
                                                                                        <div class="space8"></div>
                                                                                        <p><?php echo BaseHelper::clean($speakerTitle); ?></p>
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                    <div class="space24"></div>
                                                                <?php endif; ?>
                                                                <div class="btn-area1">
                                                                    <a href="<?php echo e($event->url); ?>" class="vl-btn9"
                                                                    ><span class="demo text-white"><?php echo e(__('purchase ticket now')); ?></span></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-5">
                                                            <div class="img1">
                                                                <?php echo e(RvMedia::image($event->image, $event->name, 'small-rectangle')); ?>

                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="space30"></div>
                                    </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify-homepage09/partials/shortcodes/events-schedule/styles/style-2.blade.php ENDPATH**/ ?>