<?php
    $variablesStyle = [];
    $style = $shortcode->style;
    $style = in_array($style, range(1, 5)) ? $style : 1;
    $contactMethod = Shortcode::fields()->getTabsData(['title', 'description', 'icon_image', 'url'], $shortcode);
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;
    $iconBgImage = $shortcode->icon_bg_image ? RvMedia::getImageUrl($shortcode->icon_bg_image) : null;
    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
        $variablesStyle["--shortcode-text-color-2: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }
    if ($iconBgImage) {
        $variablesStyle["--shortcode-background-image-icon: url($iconBgImage)"] = $iconBgImage;
    }
?>

<?php echo Theme::partial(
    'shortcodes.contact.contact-information.styles.style-' . $style,
    compact('contactMethod', 'shortcode', 'variablesStyle','form'),
); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/shortcodes/contact/contact-information/index.blade.php ENDPATH**/ ?>