<?php
    Theme::set('pageTitle', $event->name);

    if ($coverImage = $event->getMetaData('cover_image', true)) {
        Theme::set('breadcrumb_background_image', $coverImage);
    }
?>

<?php echo apply_filters('ads_render', null, 'event_before', ['class' => 'mb-2']); ?>


<div class="event-sidepage-section-area sp8 event-detail">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <div class="event-side-images">
                    <div class="img1">
                        <?php echo e(RvMedia::image($event->image, $event->name, 'large')); ?>

                    </div>
                    <div class="space32"></div>
                    <h3><?php echo e($event->name); ?></h3>

                    <?php if($content = $event->content): ?>
                        <div class="space16"></div>
                        <div class="ck-content">
                            <?php echo BaseHelper::clean($content); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($speakers = $event->speakers): ?>
                        <div class="space40"></div>
                        <h4><?php echo e(__('Event Speakers')); ?></h4>
                        <?php echo Theme::partial('event-booking.speakers', compact('speakers')); ?>

                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-5">
                <?php echo Theme::partial('event-booking.event-sidebar', compact('event')); ?>

            </div>
        </div>
    </div>
</div>

<?php echo apply_filters('ads_render', null, 'event_after', ['class' => 'mt-2']); ?>


<?php echo dynamic_sidebar('event_list_sidebar'); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/events-booking/event.blade.php ENDPATH**/ ?>