<?php use \Botble\Theme\Supports\ThemeSupport; ?>

<div class="team9-section-rea sp1 shortcode-speakers shortcode-speaker-style-8" style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="heading12 space-margin60">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <h5><?php echo BaseHelper::clean($subtitle); ?></h5>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3"><?php echo BaseHelper::clean($title); ?></h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="team-slider-area8 owl-carousel">
                    <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speaker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="team-widget-boxarea">
                            <div class="img1 image-anime">
                                <?php echo e(RvMedia::image($speaker->avatar, $speaker->name, 'medium-rectangle-vertical')); ?>


                                <?php if($socials = $speaker->getMetaData('socials', true)): ?>
                                    <?php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    ?>
                                    <ul>
                                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a class="icon<?php echo e($loop->index + 1); ?>" title="<?php echo e($social->getName()); ?>"
                                                   href="<?php echo e($social->getUrl()); ?>" target="_blank">
                                                    <?php echo $social->getIconHtml(); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <div class="space20"></div>
                            <div class="text-area">
                                <a href="<?php echo e($speaker->url); ?>"><?php echo e($speaker->name); ?></a>
                                <?php if($speakerTitle = $speaker->getMetaData('title', true)): ?>
                                    <div class="space16"></div>
                                    <p><?php echo BaseHelper::clean($speakerTitle); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify-homepage09/partials/shortcodes/speakers/styles/style-8.blade.php ENDPATH**/ ?>