<?php
    $title = theme_option('event_list_title');
    $currentPage = $events->currentPage();
    $perPage = $events->perPage();
    $eventMetaDisplay = json_decode(theme_option('event_list_meta_display', []), true);
    $shouldDisplayDateTime = in_array('date_time', $eventMetaDisplay);
    $shouldDisplayOrganizerName = in_array('organizer_name', $eventMetaDisplay);
    $shouldDisplayOrganizerTitle = in_array('organizer_title', $eventMetaDisplay);
    $shouldDisplayOrganizerImage = in_array('organizer_image', $eventMetaDisplay);
    $shouldDisplayAddress = in_array('address', $eventMetaDisplay);
?>

<?php echo apply_filters('ads_render', null, 'event_list_before', ['class' => 'mb-2']); ?>


<div class="event-team-area sp1 event-list">
    <div class="container">
        <?php if($title): ?>
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="heading2 text-center space-margin60">
                        <h2><?php echo BaseHelper::clean($title); ?></h2>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12 m-auto">
                <div class="event-widget-area">
                    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $organizer = $event->organizer;
                            $number = ($currentPage - 1) * $perPage + $key + 1;
                        ?>
                        <div class="row">
                            <div class="col-lg-10 m-auto">
                                <?php if($key % 2 == 0): ?>
                                    <?php echo Theme::partial(
                                        'event-booking.event-start',
                                        compact(
                                            'event',
                                            'organizer',
                                            'number',
                                            'shouldDisplayDateTime',
                                            'shouldDisplayOrganizerName',
                                            'shouldDisplayOrganizerTitle',
                                            'shouldDisplayOrganizerImage',
                                            'shouldDisplayAddress',
                                        ),
                                    ); ?>

                                <?php else: ?>
                                    <?php echo Theme::partial(
                                        'event-booking.event-end',
                                        compact(
                                            'event',
                                            'organizer',
                                            'number',
                                            'shouldDisplayDateTime',
                                            'shouldDisplayOrganizerName',
                                            'shouldDisplayOrganizerTitle',
                                            'shouldDisplayOrganizerImage',
                                            'shouldDisplayAddress',
                                        ),
                                    ); ?>

                                <?php endif; ?>
                                <?php if(!$loop->last): ?>
                                    <div class="space48"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if($events instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator && $events->total() > 0): ?>
                    <div class="space60"></div>
                    <?php echo e($events->withQueryString()->links(Theme::getThemeNamespace('partials.pagination'))); ?>

                <?php endif; ?>
            </div>

        </div>
    </div>
</div>

<?php echo apply_filters('ads_render', null, 'event_list_after', ['class' => 'mt-2']); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/events-booking/events.blade.php ENDPATH**/ ?>