<?php
    $bgImage = Theme::get('breadcrumb_background_image') ?: theme_option('breadcrumb_background_image');
    $bgImage = $bgImage ? RvMedia::getImageUrl($bgImage) : null;

    $bgColor = Theme::get('breadcrumb_background_color');
    $bgColor = $bgColor && $bgColor !== 'transparent' ? $bgColor  : theme_option('breadcrumb_background_color');

    $textColor = Theme::get('breadcrumb_text_color');
    $textColor = $textColor && $textColor !== 'transparent' ? $textColor : theme_option('breadcrumb_text_color');

    $height = Theme::get('breadcrumb_height') ?: theme_option('breadcrumb_height');
    $height = (int) $height ? $height . 'px' : 'auto';
    $hasTextColor = $textColor && $textColor !== 'transparent';
?>

<?php if($pageTitle = Theme::get('pageTitle')): ?>
    <div class="breadcrumb__area inner-page-header"
        style="<?php echo \Illuminate\Support\Arr::toCssStyles([
            '--breadcrumb-bg-color: ' . $bgColor => $bgColor,
            '--breadcrumb-bg-image: ' . "url('$bgImage')" => $bgImage,
            '--breadcrumb-txt-color: ' . $textColor => $hasTextColor,
            '--breadcrumb-height: ' . $height => $height,
        ]) ?>"
    >
        <div class="container">
            <div class="row">
                <div class="" style="text-align: start;">
                    <?php if(Theme::breadcrumb()->enabled()): ?>
                        <div class="space20"></div>
                        <?php $__currentLoopData = Theme::breadcrumb()->getCrumbs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(! $loop->last): ?>
                                <a class="breadcrumb-item" href="<?php echo e($crumb['url']); ?>" title="<?php echo e($crumb['label']); ?>">
                                    <?php echo e($crumb['label']); ?>

                                </a>

                                <?php if (isset($component)) { $__componentOriginal73995948b3bd877b76251b40caf28170 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73995948b3bd877b76251b40caf28170 = $attributes; } ?>
<?php $component = Botble\Icon\View\Components\Icon::resolve(['name' => 'ti ti-chevron-right'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('core::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Botble\Icon\View\Components\Icon::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $attributes = $__attributesOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__attributesOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73995948b3bd877b76251b40caf28170)): ?>
<?php $component = $__componentOriginal73995948b3bd877b76251b40caf28170; ?>
<?php unset($__componentOriginal73995948b3bd877b76251b40caf28170); ?>
<?php endif; ?>
                            <?php else: ?>
                                <span class="breadcrumb-item active"><?php echo e($crumb['label']); ?></span>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <h1><?php echo BaseHelper::clean($pageTitle); ?></h1>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/partials/breadcrumbs.blade.php ENDPATH**/ ?>