<?php
    Theme::set('pageTitle', __('Blog Details'));

    $socialLinks = json_decode(theme_option('social_links', []), true);
    $tags = $post->tags ?? [];
    $categories = $post->categories;

    if ($coverImage = $post->getMetaData('cover_image', true)) {
        Theme::set('breadcrumb_background_image', $coverImage);
    }
?>

<?php echo apply_filters('ads_render', null, 'post_before', ['class' => 'mb-2']); ?>


<div class="blog-details-section sp8">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="blog-deatils-content heading2">
                    <?php if($image = $post->image): ?>
                        <div class="img1">
                            <?php echo e(RvMedia::image($image, $post->name, 'medium')); ?>

                        </div>
                    <?php endif; ?>
                    <div class="space32"></div>
                    <?php echo Theme::partial('blogs.post-meta', [
                        'post' => $post,
                    ]); ?>


                    <?php if($name = $post->name): ?>
                        <div class="space18"></div>
                        <h2><?php echo e($name); ?></h2>
                    <?php endif; ?>
                    <?php if($description = $post->description): ?>
                        <div class="space16"></div>
                        <p><?php echo e($description); ?></p>
                    <?php endif; ?>

                    <div class="space48"></div>
                    <?php if($content = $post->content): ?>
                        <div class="ck-content">
                            <?php echo BaseHelper::clean($content); ?>

                        </div>
                    <?php endif; ?>

                    <div class="space32"></div>
                    <div class="tags-social-area">
                        <div class="tags">
                            <h4><?php echo e(__('Tags:')); ?></h4>
                            <ul>
                                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e($tag->url); ?>">#<?php echo e($tag->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <?php
                            $socials = \Botble\Theme\Supports\ThemeSupport::getSocialSharingButtons(
                                $post->url,
                                $post->name,
                                RvMedia::getImageUrl($post->image),
                            );
                        ?>
                        <?php if($socials): ?>
                            <div class="<?php echo \Illuminate\Support\Arr::toCssClasses(['details-share']); ?>">
                                <h6><?php echo e(__('Share:')); ?></h6>
                                <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a
                                        target="_blank"
                                        href="<?php echo e($social['url']); ?>"
                                    >
                                        <?php echo $social['icon']; ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="space30 d-lg-none d-block"></div>
                <div class="blog-auhtor-details">
                    <?php echo dynamic_sidebar('blog_sidebar'); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $post); ?>


<div class="bloginner-section-area sp1">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 m-auto">
                <div class="heading2 text-center space-margin60">
                    <h2><?php echo e(__('Read More Blogs')); ?></h2>
                </div>
            </div>
        </div>

        <?php echo Theme::partial('blogs.related.index', compact('post')); ?>


    </div>
</div>

<?php echo apply_filters('ads_render', null, 'post_after', ['class' => 'mt-2']); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify/views/post.blade.php ENDPATH**/ ?>