<?php
    $style = [];
    $bgColor = theme_option('header_background_color', '#313131');
    $textColor = theme_option('header_text_color', '#ffffff');
    $isTransparent = theme_option('is_header_transparent', false) && Theme::get('isHomepage');

    if ($textColor) {
        $style["--header-text-color: $textColor"] = $textColor;
    }

    if ($bgColor !== 'transparent') {
        $style["--header-background-color: $bgColor"] = $bgColor;
    }
?>

<?php echo apply_filters('ads_render', null, 'header_before', ['class' => 'mb-2']); ?>


<header>
    <?php if(theme_option('display_header_top', false)): ?>
        <?php echo Theme::partial('header.header-top', ['headerWrapperClass' => 'home-main']); ?>

    <?php endif; ?>

    <div
        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
            'header-area homepage9 header header-sticky d-none d-lg-block',
            'no-transparent' => !$isTransparent,
        ]); ?>"
        id="header"
        style="<?php echo \Illuminate\Support\Arr::toCssStyles($style) ?>"
    >
        <?php echo Theme::partial('header.content'); ?>

    </div>
</header>

<?php echo apply_filters('ads_render', null, 'header_after', ['class' => 'mt-2']); ?>


<?php echo Theme::partial('header.mobile'); ?>

<?php /**PATH /home/u105110351/domains/gatasworld.com/public_html/tickets/platform/themes/eventify-homepage09/partials/header/index.blade.php ENDPATH**/ ?>