export const WelcomeImage = () => {
    return (
        <svg
            width="152"
            height="152"
            viewBox="0 0 152 152"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M31.3379 45.9943V45.7861C31.3379 45.8555 31.3379 45.9018 31.3611 45.9711L31.3379 45.9943Z"
                fill="#4EA6EC"
            />
            <path
                d="M119.194 42.2459V45.3002C119.055 44.1664 118.454 43.102 117.412 42.3847C92.0527 24.9616 58.502 24.9616 33.1191 42.3847C31.9622 43.1946 31.3375 44.4904 31.3375 45.7861V42.3154C31.3144 40.9965 31.9392 39.6776 33.1191 38.8678C58.502 21.4445 92.0527 21.4445 117.412 38.8678C118.569 39.6776 119.171 40.9501 119.171 42.2459H119.194Z"
                fill="#4EA6EC"
            />
            <g opacity="0.49">
                <path
                    d="M85.9503 31.7067C85.9401 31.7067 85.9273 31.7067 85.9145 31.7041C79.4917 30.919 74.0597 31.1696 74.3235 31.1718C73.9487 31.1718 73.9347 30.6055 74.3159 30.5934C78.1983 30.4808 82.1242 30.6574 85.9861 31.1308C86.1448 31.1487 86.2574 31.2946 86.2369 31.4533C86.219 31.5992 86.0936 31.7067 85.9503 31.7067Z"
                    fill="white"
                />
            </g>
            <path
                d="M29.9482 70.5739C34.6155 65.9757 26.6758 57.4324 35.0949 51.3282C36.7533 50.1279 38.8391 49.2757 41.296 48.7895C41.6215 48.6949 41.7479 49.2314 41.3984 49.3013C39.0157 49.7748 36.999 50.5989 35.402 51.7531C27.1583 57.7413 35.3381 65.9941 30.3167 70.9476C30.0737 71.1906 29.6993 70.8228 29.9482 70.5739Z"
                fill="#3D444C"
            />
            <path
                d="M29.9049 72.7414L30.514 71.9276C30.6599 71.7305 30.624 71.4567 30.4347 71.3134C30.0543 71.0517 29.7898 70.7321 29.5236 70.7913C29.0183 70.8572 28.6993 72.1748 28.2567 71.8329C28.139 71.7459 28.116 71.5821 28.203 71.4669L28.8095 70.6531C29.1436 70.204 29.7595 70.1481 30.1531 70.4509L30.7469 70.8936C31.1692 71.2084 31.2511 71.8124 30.9337 72.2398L30.3246 73.0537C30.1184 73.3321 29.6961 73.0177 29.9049 72.7414Z"
                fill="#3D444C"
            />
            <path
                d="M22.4679 81.0292C26.1885 83.8119 31.5414 80.3808 30.6529 75.7117L25.2562 71.6753C20.5145 72.1459 18.7502 78.2487 22.4679 81.0292Z"
                fill="#FF6866"
            />
            <path
                d="M23.9863 71.9643C24.3981 71.815 24.825 71.7176 25.2563 71.6753L30.6528 75.7114C30.7341 76.1372 30.7612 76.5742 30.7344 77.0114L23.9863 71.9643Z"
                fill="#F14642"
            />
            <path
                d="M24.2959 70.957C24.136 71.1707 24.1767 71.4713 24.3867 71.6284L30.9443 76.533C31.1543 76.6901 31.4542 76.6442 31.614 76.4305C31.7738 76.2168 31.7331 75.9162 31.5231 75.7592L24.9655 70.8545C24.7555 70.6975 24.4557 70.7434 24.2959 70.957Z"
                fill="#505660"
            />
            <path
                d="M22.3398 72.9277C22.7266 72.8357 23.0173 72.8301 23.3221 73.0581C24.1559 73.6817 23.2243 75.2043 24.4169 76.0963C25.6213 76.997 26.7858 75.6487 27.6407 76.2881C28.4786 76.9148 27.5341 78.4277 28.7349 79.3258C29.1091 79.6057 29.4869 79.6701 29.8427 79.6447C30.0119 79.3918 30.1573 79.1289 30.2783 78.8593C29.8187 78.9829 29.4951 79.0198 29.1544 78.765C28.311 78.1342 29.2664 76.6294 28.0601 75.7272C26.8558 74.8264 25.6912 76.1748 24.8364 75.5354C24.0026 74.9118 24.9342 73.3892 23.7416 72.4972C23.5986 72.3903 23.4549 72.3147 23.3119 72.2637C22.969 72.4455 22.6419 72.6672 22.3398 72.9277Z"
                fill="white"
            />
            <path
                d="M20.7948 75.1479C20.711 75.3729 20.6441 75.6019 20.5928 75.8329C20.7943 75.8311 20.9753 75.8834 21.1621 76.0231C21.9942 76.6455 21.0672 78.1705 22.2574 79.0607C23.4418 79.9465 24.6433 78.6268 25.4807 79.2531C26.2362 79.8182 25.5639 81.0503 26.2399 81.9573C26.5125 81.915 26.7822 81.8513 27.0463 81.7659C27.03 81.7547 27.0125 81.7426 26.9954 81.7298C26.1616 81.1062 27.0928 79.5842 25.9001 78.6922C24.7157 77.8064 23.5142 79.1261 22.6769 78.4998C21.843 77.8762 22.7742 76.3542 21.5816 75.4622C21.3181 75.2652 21.0527 75.1748 20.7948 75.1479Z"
                fill="white"
            />
            <path
                d="M26.6699 70.9768L26.1172 71.7157L30.5861 75.0581L31.1387 74.3192C31.3641 74.0179 31.3067 73.5941 31.0106 73.3726L27.6141 70.8323C27.318 70.6108 26.8952 70.6755 26.6699 70.9768Z"
                fill="#505660"
            />
            <path
                d="M26.4227 71.3092L26.1182 71.7163L30.5862 75.0581L30.8907 74.6509L26.4227 71.3092Z"
                fill="#3D444C"
            />
            <path
                d="M121.68 70.9474C118.039 67.3606 121.384 61.587 120.245 56.9149C119.175 52.5747 114.993 50.1734 110.599 49.3011C110.25 49.2314 110.374 48.6981 110.701 48.7893C116.786 49.9923 119.916 53.3725 120.751 56.7921C121.873 61.3523 118.742 67.3207 122.049 70.5737C122.298 70.8226 121.923 71.1904 121.68 70.9474Z"
                fill="#3D444C"
            />
            <path
                d="M70.4814 94.6592V101.953C70.4814 104.634 72.615 106.768 75.296 106.768C77.8258 106.768 80.0607 104.77 80.0607 101.953V94.6592H70.4814Z"
                fill="#FB8386"
            />
            <path
                d="M70.4814 94.6592V97.985C73.409 99.3244 77.0336 99.3742 80.0607 98.1344V94.6592H70.4814Z"
                fill="#E86B74"
            />
            <path
                d="M59.8975 138.897H91.2283V106.715C91.2283 104.939 89.7894 103.5 88.0133 103.5H61.7685C60.7346 103.5 59.8975 104.337 59.8975 105.371V138.897Z"
                fill="#2563EB"
            />
            <path
                d="M77.1094 101.566V103.499H82.3357V101.566C82.3357 101.055 81.9216 100.641 81.4102 100.641H78.0347C77.5234 100.641 77.1094 101.055 77.1094 101.566Z"
                fill="#2563EB"
            />
            <path
                d="M68.377 101.555V103.499H73.6349V101.555C73.6349 101.042 73.2164 100.623 72.7028 100.623H69.3091C68.7932 100.623 68.377 101.042 68.377 101.555Z"
                fill="#2563EB"
            />
            <path
                d="M73.6338 103.499V111.766C73.6338 112.725 74.4121 113.503 75.3713 113.503C76.3306 113.503 77.1089 112.725 77.1089 111.766V103.499H73.6338Z"
                fill="#FCB21F"
            />
            <path
                d="M74.4648 106.378C74.4648 106.869 74.8697 107.274 75.3608 107.274C75.8517 107.274 76.2589 106.869 76.2589 106.378C76.2589 105.887 75.8517 105.482 75.3608 105.482C74.8697 105.482 74.4648 105.887 74.4648 106.378Z"
                fill="#EDF1FC"
            />
            <path
                d="M74.4648 110.303C74.4648 110.794 74.8697 111.199 75.3608 111.199C75.8517 111.199 76.2589 110.794 76.2589 110.303C76.2589 109.812 75.8517 109.407 75.3608 109.407C74.8697 109.407 74.4648 109.812 74.4648 110.303Z"
                fill="#EDF1FC"
            />
            <path
                d="M106.141 91.8486L85.7875 104.469C82.421 106.566 81.3417 111.003 83.4187 114.365L84.4323 115.987C84.4323 115.987 110.514 99.7176 110.992 99.2673L106.141 91.8486Z"
                fill="#2563EB"
            />
            <path
                d="M108.992 49.7496C111.497 49.736 113.538 51.7655 113.538 54.27L113.549 66.0734H104.485L104.472 54.2814C104.472 51.7768 106.488 49.7496 108.992 49.7496Z"
                fill="#FE9D97"
            />
            <path
                d="M113.547 62.2988L104.482 62.3096L104.487 66.0781L113.552 66.0674L113.547 62.2988Z"
                fill="#FC908E"
            />
            <path
                d="M113.562 95.2666V95.2915C113.562 97.7825 111.534 99.812 109.043 99.8233C106.539 99.8233 104.509 97.7961 104.498 95.3051L104.484 66.0737H113.55L113.562 95.2666Z"
                fill="#2563EB"
            />
            <path
                d="M104.4 67.0411H113.796C114.269 67.0411 114.656 66.6565 114.656 66.1814V65.0253C114.656 64.5502 114.269 64.1655 113.796 64.1655H104.4C103.925 64.1655 103.54 64.5502 103.54 65.0253V66.1814C103.54 66.6565 103.925 67.0411 104.4 67.0411Z"
                fill="#FCB21F"
            />
            <path
                d="M44.303 91.5269L64.6563 104.147C68.0228 106.244 69.1021 110.681 67.0251 114.043L66.0115 115.665C66.0115 115.665 39.9295 99.3958 39.4521 98.9456L44.303 91.5269Z"
                fill="#2563EB"
            />
            <path
                d="M41.4522 49.4278C38.9475 49.4142 36.9068 51.4437 36.9068 53.9483L36.8955 65.7516H45.959L45.9727 53.9596C45.9727 51.455 43.9568 49.4278 41.4522 49.4278Z"
                fill="#FE9D97"
            />
            <path
                d="M45.9624 62.3042H36.8975V65.7504H45.9624V62.3042Z"
                fill="#FC908E"
            />
            <path
                d="M36.8828 94.9697C36.8828 97.4607 38.91 99.4902 41.4009 99.5015C43.9054 99.5015 45.9328 97.4743 45.9463 94.9833L45.9598 65.752H36.894C36.8939 66.0254 36.8828 95.2346 36.8828 94.9697Z"
                fill="#2563EB"
            />
            <path
                d="M46.044 66.7194H36.6478C36.1749 66.7194 35.7881 66.3348 35.7881 65.8596V64.7035C35.7881 64.2284 36.1749 63.8438 36.6478 63.8438H46.044C46.519 63.8438 46.9036 64.2284 46.9036 64.7035V65.8596C46.9036 66.3348 46.519 66.7194 46.044 66.7194Z"
                fill="#FCB21F"
            />
            <path
                d="M66.2411 77.154C63.1966 74.9102 60.7113 71.6532 61.8981 68.0763C62.4893 66.2951 63.6716 64.9412 65.0588 64.4575C67.38 63.6513 69.7576 64.3168 70.9655 64.7877C71.2896 64.9099 71.0969 65.4071 70.7762 65.2739C69.6347 64.8312 67.3954 64.199 65.2328 64.954C63.9967 65.384 62.9371 66.6124 62.3946 68.2401C61.2848 71.592 63.7244 74.6451 66.5534 76.7343C66.8299 76.9371 66.5219 77.3609 66.2411 77.154Z"
                fill="#521B42"
            />
            <path
                d="M64.9715 78.1066C64.2607 76.9531 61.9278 77.1518 61.6909 79.0794C61.589 79.9211 61.9872 80.8148 62.4511 81.5003C63.2994 82.7561 64.6775 82.6885 65.2633 82.3239L64.9715 78.1066Z"
                fill="#FE9D97"
            />
            <path
                d="M64.7888 78.8359C64.1064 77.7252 61.7903 78.7514 63.2525 80.9038C63.767 81.6662 64.6055 81.6337 64.9651 81.4083L64.7888 78.8359Z"
                fill="#FD8285"
            />
            <path
                d="M86.1532 78.1062C86.6034 77.3754 87.5876 77.2623 88.3343 77.5496C90.5556 78.4083 89.0572 82.4848 86.9496 82.5429C86.5853 82.5543 86.203 82.5362 85.8613 82.3235L86.1532 78.1062Z"
                fill="#FE9D97"
            />
            <path
                d="M86.3357 78.8357C86.7721 78.1251 88.1984 78.2653 88.3356 79.4285C88.43 80.193 87.7777 81.5127 86.822 81.5416C86.598 81.5484 86.3649 81.5371 86.1592 81.4082L86.3357 78.8357Z"
                fill="#FD8285"
            />
            <path
                d="M86.2445 85.1466L86.0182 74.8658C85.8937 69.1349 81.2104 64.5557 75.4795 64.5557C69.665 64.5557 64.9476 69.2639 64.9385 75.0785L64.9204 85.1466C62.5471 101.574 88.2784 101.384 86.2445 85.1466Z"
                fill="#FE9D97"
            />
            <path
                d="M67.249 85.1086C67.249 86.1901 68.145 87.0566 69.2287 87.0566C70.3101 87.0566 71.1766 86.1901 71.1766 85.1086C71.1766 84.0272 70.3101 83.1606 69.2287 83.1606C68.145 83.1606 67.249 84.0272 67.249 85.1086Z"
                fill="#FC908E"
            />
            <path
                d="M79.9707 85.1086C79.9707 86.1901 80.8666 87.0566 81.9504 87.0566C83.0318 87.0566 83.8983 86.1901 83.8983 85.1086C83.8983 84.0272 83.0318 83.1606 81.9504 83.1606C80.8666 83.1606 79.9707 84.0272 79.9707 85.1086Z"
                fill="#FC908E"
            />
            <path
                d="M73.2744 87.908C73.2744 87.5616 73.7965 87.5622 73.7965 87.908C73.7965 89.3307 76.7499 89.3312 76.7499 87.908C76.7499 87.5616 77.272 87.5622 77.272 87.908C77.272 90.017 73.2744 90.0304 73.2744 87.908Z"
                fill="#D0445E"
            />
            <path
                d="M70.0605 79.5734C70.0605 79.9331 70.3545 80.2295 70.7166 80.2295C71.0447 80.2295 71.3387 79.9331 71.3387 79.5734C71.3387 79.2453 71.0447 78.9512 70.7166 78.9512C70.3545 78.9512 70.0605 79.2453 70.0605 79.5734Z"
                fill="#181E1E"
            />
            <path
                d="M69.052 77.7707C69.9119 77.1104 70.8921 76.967 71.9696 77.3561C72.314 77.4772 72.0921 77.9817 71.7955 77.8474C70.8844 77.5224 70.0885 77.6325 69.3745 78.1853C69.0922 78.3932 68.782 77.9854 69.052 77.7707Z"
                fill="#181E1E"
            />
            <path
                d="M81.0859 79.5734C81.0859 79.9331 80.7918 80.2295 80.4297 80.2295C80.1016 80.2295 79.8076 79.9331 79.8076 79.5734C79.8076 79.2453 80.1016 78.9512 80.4297 78.9512C80.7918 78.9512 81.0859 79.2453 81.0859 79.5734Z"
                fill="#181E1E"
            />
            <path
                d="M81.7735 78.1853C81.0595 77.635 80.2635 77.525 79.3524 77.8474C79.0566 77.9814 78.8341 77.4772 79.1784 77.3561C80.2533 76.967 81.2361 77.1104 82.096 77.7707C82.3686 77.9875 82.0529 78.3911 81.7735 78.1853Z"
                fill="#181E1E"
            />
            <path
                d="M84.4218 74.4548C81.9129 75.1853 78.8918 75.1339 77.6682 74.9344C71.5715 73.9271 68.7516 68.9327 70.0052 64.9455C70.4939 63.3844 72.4758 62.5179 73.9465 62.2079C75.4011 61.9002 76.9034 61.9613 78.39 62.0247C82.1819 62.1888 86.5745 62.477 88.9037 65.8324C89.9761 67.3754 90.3064 69.6108 89.3381 71.2941C88.3856 72.9525 86.1843 73.9389 84.4218 74.4548Z"
                fill="#521B42"
            />
            <path
                d="M71.111 68.9827C70.6211 71.3618 67.8096 73.0529 65.6675 73.5982C64.1518 73.9963 64.3309 74.0797 63.8371 72.6615C62.962 70.1878 63.3549 67.4885 64.2715 66.089C65.379 64.4065 67.9327 63.6862 70.6472 65.1229C71.5075 65.5763 71.9044 66.0019 72.2715 66.8628C72.8899 68.3005 72.368 68.8005 71.0115 69.8628"
                fill="#521B42"
            />
            <path
                d="M78.0631 76.0609C74.3394 75.1882 70.4826 72.8772 70.2497 69.673C70.2395 69.5297 70.347 69.4043 70.4928 69.394C70.6208 69.4068 70.7616 69.4939 70.7718 69.6372C71.2544 76.3068 88.3345 78.7202 90.1326 72.048C90.2285 71.7186 90.7324 71.8513 90.6394 72.1862C89.4679 76.4726 82.6527 77.1297 78.0631 76.0609Z"
                fill="#521B42"
            />
            <path
                d="M73.4912 83.7616C73.4912 84.5105 74.4142 85.1078 75.5613 85.1078C77.6365 85.1078 78.2206 83.5412 77.0817 82.8136V80.0466C77.0817 79.248 76.4098 78.5986 75.5862 78.5986C74.7378 78.5986 74.0636 79.248 74.0636 80.0466V82.8136C73.7152 83.0376 73.4912 83.3883 73.4912 83.7616Z"
                fill="#F76373"
            />
            <path
                d="M118.361 48.2441C115.942 51.3618 113.526 54.4795 111.107 57.595C109.82 59.2556 107.462 59.6697 105.72 58.4977C87.3283 46.1196 63.2124 46.1196 44.8206 58.4977C43.0784 59.6697 40.7209 59.2556 39.4336 57.595C37.015 54.4795 34.5986 51.3618 32.1801 48.2441C30.7411 46.3889 31.1936 43.7191 33.128 42.391C58.4951 24.9654 92.0455 24.9654 117.413 42.391C119.347 43.7191 119.799 46.3889 118.361 48.2441Z"
                fill="#3C90DC"
            />
            <g opacity="0.49">
                <path
                    d="M43.2694 39.0158C51.5409 35.1666 59.6 32.8224 67.2241 32.0469C67.5649 32.0141 67.6252 32.5322 67.2753 32.569C59.7127 33.3368 51.7098 35.6657 43.4895 39.4918C43.1626 39.6319 42.9626 39.1602 43.2694 39.0158Z"
                    fill="white"
                />
            </g>
            <path
                d="M52.8338 39.8193C53.1786 48.2392 53.4262 48.1556 53.048 48.6695C52.6278 49.247 51.7367 49.4152 51.2307 48.8867L47.1396 44.4117C47.3911 50.6728 47.6326 50.6018 47.2653 51.1169C46.8579 51.6976 45.9448 51.8484 45.4546 51.3296C39.6944 45.1186 39.7524 45.3067 39.5993 44.9482C39.1931 43.9727 40.5596 43.1398 41.324 43.9383L45.5931 48.662L45.2616 42.3026C45.2209 41.3634 46.3316 40.8334 47.0165 41.5753L51.2993 46.3653L50.9008 39.8869C50.8483 38.6751 52.707 38.2951 52.8338 39.8193Z"
                fill="white"
            />
            <path
                d="M57.3885 47.1134C57.1802 46.9886 57.0376 46.7706 56.9609 46.4638C55.181 38.9364 54.8821 38.8722 55.2104 38.3243C55.5307 37.7899 55.9485 37.9535 60.5248 36.7411C61.1735 36.5808 61.5656 36.7644 61.6965 37.2918C61.8274 37.8258 61.5685 38.174 60.9198 38.3365L57.2965 39.2348L57.8337 41.4083L61.1944 40.5755C61.8454 40.4152 62.2352 40.601 62.3684 41.1372C62.4993 41.6646 62.2404 42.0084 61.5894 42.1709L58.2309 43.0015L58.8087 45.334L62.432 44.4379C63.0808 44.2754 63.4728 44.4634 63.606 44.9996C63.7369 45.527 63.4758 45.8708 62.827 46.0311C58.2214 47.0941 57.9288 47.4372 57.3885 47.1134Z"
                fill="white"
            />
            <path
                d="M64.6885 44.6583C63.752 37.158 63.4043 36.9105 63.8385 36.3351C64.2835 35.7516 65.5977 35.6964 65.7568 36.8399L66.6872 43.6448L70.1315 43.176C70.7851 43.0865 71.1509 43.3276 71.229 43.9017C71.3071 44.4669 71.0194 44.7932 70.3636 44.8828L65.8043 45.5076C65.168 45.5916 64.7753 45.282 64.6885 44.6583Z"
                fill="white"
            />
            <path
                d="M71.224 39.9465C71.1343 36.9245 72.9078 34.9954 75.7492 34.9139C76.9333 34.879 77.9645 35.1763 78.8449 35.8014C79.6908 36.4493 79.0482 37.9442 77.9198 37.2004C77.2314 36.7782 76.6557 36.5743 75.906 36.5923C74.0004 36.6507 73.3263 37.9631 73.3801 39.8844C73.4422 42.0383 74.3469 43.0897 76.0922 43.0387C77.2541 43.002 77.9642 42.31 78.403 42.1362C79.2884 41.7988 79.7995 43.042 79.0716 43.6594C76.4344 45.7807 71.3617 44.9745 71.224 39.9465Z"
                fill="white"
            />
            <path
                d="M85.7338 35.337C88.6415 35.6342 90.1783 37.7665 89.8736 40.6933C89.5523 43.7807 87.4702 45.3847 84.7198 45.0972C78.4625 44.4562 79.4502 34.6785 85.7338 35.337ZM87.3562 37.9954C86.5563 36.7757 84.6123 36.588 83.6091 37.6062C82.5928 38.6287 82.3183 41.2104 83.1151 42.4343C83.5071 43.0399 84.0988 43.3815 84.8903 43.4635C87.9184 43.7774 88.3137 39.4583 87.3562 37.9954Z"
                fill="white"
            />
            <path
                d="M101.981 39.7416C99.9679 47.193 100.18 47.496 99.6216 47.8231C99.0463 48.1662 97.9836 47.7506 98.2482 46.7387L99.4502 42.0991C96.625 45.0455 96.4664 45.7718 95.584 45.544C94.7594 45.3307 94.8579 44.5896 93.8619 40.7208C92.6266 45.1809 92.8011 45.5726 92.2517 45.9061C91.6711 46.2611 90.6132 45.8339 90.8762 44.8284C92.937 37.2258 92.6676 37.079 93.2686 36.7048C93.7672 36.3914 94.634 36.5745 94.8306 37.523L96.1863 43.2739L100.152 38.9027C101.034 37.9332 102.262 38.6662 101.981 39.7416Z"
                fill="white"
            />
            <path
                d="M101.723 47.7615C104.564 40.9786 104.501 40.3988 105.097 40.1498C105.674 39.9087 105.902 40.2811 110.325 41.9984C110.945 42.2493 111.153 42.6282 110.948 43.1308C110.741 43.6423 110.326 43.7726 109.706 43.5196L106.247 42.1125L105.403 44.1872L108.609 45.4917C109.229 45.7448 109.437 46.126 109.23 46.6375C109.024 47.1401 108.612 47.266 107.992 47.0129L104.786 45.7083L103.878 47.9336L107.337 49.3407C107.957 49.5938 108.164 49.9749 107.955 50.4864C107.752 50.9891 107.34 51.1149 106.717 50.8619L102.267 49.0512C101.698 48.8219 101.476 48.3638 101.723 47.7615Z"
                fill="white"
            />
            <path
                d="M121.67 73.0538L121.063 72.24C120.746 71.8126 120.828 71.2086 121.25 70.8938C121.683 70.6228 121.972 70.1875 122.545 70.2719C123.147 70.3554 123.275 70.8595 123.794 71.4671C124.002 71.7427 123.581 72.0613 123.374 71.7793C122.859 71.1416 122.777 70.8314 122.471 70.7914C122.204 70.728 121.997 71.0161 121.562 71.3135C121.373 71.4568 121.337 71.7307 121.483 71.9278L122.089 72.7416C122.298 73.0178 121.876 73.3324 121.67 73.0538Z"
                fill="#3D444C"
            />
            <path
                d="M129.529 81.0297C125.794 83.8227 120.458 80.3641 121.344 75.7121L126.74 71.6758C131.501 72.1483 133.245 78.2505 129.529 81.0297Z"
                fill="#2563EB"
            />
            <path
                d="M128.01 71.9648C127.598 71.8155 127.171 71.7181 126.74 71.6758L121.344 75.7119C121.262 76.1377 121.235 76.5747 121.262 77.0118L128.01 71.9648Z"
                fill="#FCB21F"
            />
            <path
                d="M127.701 70.957C127.861 71.1707 127.82 71.4713 127.61 71.6284L121.052 76.533C120.842 76.6901 120.543 76.6442 120.383 76.4305C120.223 76.2168 120.264 75.9162 120.474 75.7592L127.031 70.8545C127.241 70.6975 127.541 70.7434 127.701 70.957Z"
                fill="#505660"
            />
            <path
                d="M129.657 72.9277C129.27 72.8357 128.98 72.8301 128.675 73.0581C127.841 73.6817 128.773 75.2043 127.58 76.0963C126.376 76.997 125.211 75.6487 124.356 76.2881C123.518 76.9148 124.463 78.4277 123.262 79.3258C122.888 79.6057 122.51 79.6701 122.154 79.6447C121.985 79.3918 121.84 79.1289 121.719 78.8593C122.178 78.9829 122.502 79.0198 122.843 78.765C123.686 78.1342 122.731 76.6294 123.937 75.7272C125.141 74.8264 126.306 76.1748 127.161 75.5354C127.994 74.9118 127.063 73.3892 128.255 72.4972C128.398 72.3903 128.542 72.3147 128.685 72.2637C129.028 72.4455 129.355 72.6672 129.657 72.9277Z"
                fill="white"
            />
            <path
                d="M131.202 75.1479C131.286 75.3729 131.352 75.6019 131.404 75.8329C131.202 75.8311 131.021 75.8834 130.834 76.0231C130.002 76.6455 130.929 78.1705 129.739 79.0607C128.555 79.9465 127.353 78.6268 126.516 79.2531C125.76 79.8182 126.433 81.0503 125.757 81.9573C125.484 81.915 125.214 81.8513 124.95 81.7659C124.966 81.7547 124.984 81.7426 125.001 81.7298C125.835 81.1062 124.904 79.5842 126.096 78.6922C127.281 77.8064 128.482 79.1261 129.32 78.4998C130.153 77.8762 129.222 76.3542 130.415 75.4622C130.678 75.2652 130.944 75.1748 131.202 75.1479Z"
                fill="white"
            />
            <path
                d="M125.327 70.9768L125.88 71.7157L121.411 75.0581L120.858 74.3192C120.633 74.0179 120.69 73.5941 120.987 73.3726L124.383 70.8323C124.679 70.6108 125.102 70.6755 125.327 70.9768Z"
                fill="#505660"
            />
            <path
                d="M125.573 71.3091L121.105 74.6509L121.41 75.058L125.878 71.7163L125.573 71.3091Z"
                fill="#3D444C"
            />
            <path
                d="M123.744 28.9454L124.908 28.0781C125.434 27.6861 126.168 28.1169 126.097 28.7766L125.941 30.2364C125.906 30.5672 126.085 30.8832 126.384 31.0175L127.705 31.6099C128.302 31.8776 128.302 32.7392 127.705 33.007L126.384 33.5994C126.085 33.7336 125.906 34.0496 125.941 34.3804L126.097 35.8402C126.168 36.5 125.434 36.9308 124.908 36.5387L123.744 35.6714C123.48 35.4748 123.121 35.4748 122.857 35.6714L121.693 36.5387C121.166 36.9308 120.433 36.5 120.504 35.8402L120.66 34.3804C120.695 34.0496 120.516 33.7336 120.216 33.5994L118.896 33.007C118.299 32.7392 118.299 31.8776 118.896 31.6099L120.216 31.0175C120.516 30.8832 120.695 30.5672 120.66 30.2364L120.504 28.7766C120.433 28.1169 121.166 27.6861 121.693 28.0781L122.857 28.9454C123.121 29.142 123.48 29.142 123.744 28.9454Z"
                fill="#8AD4EA"
            />
            <path
                d="M55.5366 69.8204L56.701 68.9531C57.2273 68.5611 57.9607 68.9919 57.8902 69.6516L57.7342 71.1114C57.6988 71.4422 57.8781 71.7582 58.1774 71.8925L59.4979 72.4849C60.0947 72.7526 60.0947 73.6142 59.4979 73.882L58.1774 74.4744C57.8781 74.6086 57.6988 74.9246 57.7342 75.2554L57.8902 76.7152C57.9607 77.375 57.2273 77.8058 56.701 77.4137L55.5366 76.5464C55.2727 76.3498 54.914 76.3498 54.6501 76.5464L53.4857 77.4137C52.9594 77.8058 52.226 77.375 52.2965 76.7152L52.4525 75.2554C52.4879 74.9246 52.3086 74.6086 52.0093 74.4744L50.6888 73.882C50.092 73.6142 50.092 72.7526 50.6888 72.4849L52.0093 71.8925C52.3086 71.7582 52.4879 71.4422 52.4525 71.1114L52.2965 69.6516C52.226 68.9919 52.9594 68.5611 53.4857 68.9531L54.6501 69.8204C54.914 70.017 55.2727 70.017 55.5366 69.8204Z"
                fill="#8AD4EA"
            />
            <path
                d="M76.5375 14.1202L77.702 13.2529C78.2283 12.8609 78.9617 13.2917 78.8912 13.9514L78.7352 15.4112C78.6998 15.742 78.8791 16.058 79.1784 16.1923L80.4989 16.7847C81.0957 17.0524 81.0957 17.914 80.4989 18.1818L79.1784 18.7742C78.8791 18.9084 78.6998 19.2244 78.7352 19.5552L78.8912 21.015C78.9617 21.6748 78.2283 22.1056 77.702 21.7135L76.5375 20.8462C76.2736 20.6496 75.915 20.6496 75.6511 20.8462L74.4866 21.7135C73.9603 22.1056 73.227 21.6748 73.2975 21.015L73.4535 19.5552C73.4889 19.2244 73.3095 18.9084 73.0103 18.7742L71.6898 18.1818C71.093 17.914 71.093 17.0524 71.6898 16.7847L73.0103 16.1923C73.3095 16.058 73.4889 15.742 73.4535 15.4112L73.2975 13.9514C73.227 13.2917 73.9603 12.8609 74.4866 13.2529L75.6511 14.1202C75.915 14.3168 76.2736 14.3168 76.5375 14.1202Z"
                fill="#76C045"
            />
            <path
                d="M29.1401 23.6744L30.3046 22.8071C30.8309 22.4151 31.5642 22.8459 31.4937 23.5056L31.3377 24.9654C31.3023 25.2962 31.4817 25.6122 31.7809 25.7465L33.1014 26.3389C33.6982 26.6066 33.6982 27.4682 33.1014 27.736L31.7809 28.3284C31.4817 28.4626 31.3023 28.7786 31.3377 29.1094L31.4937 30.5692C31.5642 31.229 30.8309 31.6598 30.3046 31.2677L29.1401 30.4004C28.8762 30.2038 28.5176 30.2038 28.2537 30.4004L27.0892 31.2677C26.5629 31.6598 25.8295 31.229 25.9 30.5692L26.056 29.1094C26.0914 28.7786 25.9121 28.4626 25.6128 28.3284L24.2923 27.736C23.6955 27.4682 23.6955 26.6066 24.2923 26.3389L25.6128 25.7465C25.9121 25.6122 26.0914 25.2962 26.056 24.9654L25.9 23.5056C25.8295 22.8459 26.5629 22.4151 27.0892 22.8071L28.2537 23.6744C28.5176 23.871 28.8762 23.871 29.1401 23.6744Z"
                fill="#2563EB"
            />
            <path
                d="M108.605 19.4736L104.107 23.6979C103.644 24.1331 102.915 24.1102 102.48 23.6468C102.045 23.1834 102.068 22.4549 102.531 22.0197L107.029 17.7954C107.493 17.3602 108.221 17.3831 108.656 17.8465C109.092 18.3099 109.069 19.0384 108.605 19.4736Z"
                fill="#FF6866"
            />
            <path
                d="M47.3184 23.579L42.415 19.6927C41.9099 19.2923 41.8145 18.5601 42.2021 18.0572C42.5896 17.5543 43.3133 17.4712 43.8184 17.8715L48.7217 21.7578C49.2269 22.1582 49.3222 22.8904 48.9347 23.3933C48.5471 23.8962 47.8235 23.9793 47.3184 23.579Z"
                fill="#FF6866"
            />
            <path
                d="M96.1948 57.8457C96.1948 59.4041 94.9331 60.6659 93.3747 60.6659C91.8204 60.6659 90.5586 59.4041 90.5586 57.8457C90.5586 56.2915 91.8204 55.0298 93.3747 55.0298C94.9331 55.0298 96.1948 56.2915 96.1948 57.8457Z"
                fill="#FF6866"
            />
            <path
                d="M38.5571 107.482C38.5571 109.041 37.2954 110.303 35.737 110.303C34.1827 110.303 32.9209 109.041 32.9209 107.482C32.9209 105.928 34.1827 104.667 35.737 104.667C37.2954 104.667 38.5571 105.928 38.5571 107.482Z"
                fill="#FF6866"
            />
            <path
                d="M103.908 55.3906L104.411 62.3584L105.722 62.2585C107.509 62.1224 108.891 60.8702 108.809 59.4616L108.507 55.338C108.444 54.2588 107.158 52.8661 105.789 52.9704C105.789 52.9704 103.852 53.311 103.908 55.3906Z"
                fill="#FC908E"
            />
            <path
                d="M46.5114 55.1646L46.0086 62.1323L44.6974 62.0324C42.9105 61.8963 41.5287 60.6441 41.6109 59.2355L41.9124 55.1119C41.9754 54.0327 43.2617 52.64 44.6307 52.7443C44.6307 52.7443 46.5674 53.0849 46.5114 55.1646Z"
                fill="#FC908E"
            />
        </svg>
    );
};
