<section class="ts-schedule">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 align-self-center wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="400ms">
                <div class="ts-schedule-content">
                    <h2 class="column-title">
                        <span><?php echo esc_attr( $schedule_top_title ); ?></span>
						<?php echo esc_attr( $schedule_title ); ?>
                    </h2>
                    <p>
						<?php echo wp_kses_post( $schedule_desc ); ?>
                    </p>
                </div>
            </div>
            <!-- col end-->
            <div class="col-lg-6 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="500ms">
                <div class="ts-schedule-info mb-70">
                    <ul class="nav nav-tabs" role="tablist">
						<?php
						extract( [
							'number' => $schedule_day_limit,
							'order'  => $schedule_order,
							'class'  => '',
						] );

						global $post;
						$args = array(
							'post_type'        => 'ts-schedule',
							'suppress_filters' => false,
							'posts_per_page'   => esc_attr( $number ),
							'order'            => $order
						);

						if ( isset( $schedule_term_id ) && ! empty( $schedule_term_id ) ) {
							$args['tax_query'] = array(
								array(
									'taxonomy' => 'ts-schedule_cat',
									'field'    => 'term_id',
									'terms'    => $schedule_term_id
								),
							);
						};
						$i     = 1;
						$posts = get_posts( $args );
						foreach ( $posts as $postnav ) {
							setup_postdata( $postnav );

							$schedule_day = exhibz_meta_option( $postnav->ID, 'schedule_day' );
							?>
							<?php if ( $i == 1 ) { ?>
                                <li class="nav-item" role="presentation">
                                    <a class="active" title="<?php echo get_the_title( $postnav->ID ) ?>"
                                       href="<?php echo esc_attr( "#date" . $this->get_id() . $i ); ?>" role="tab"
                                       data-toggle="tab">
                                        <h3><?php echo get_the_title( $postnav->ID ) ?></h3>
										<?php if ( ! empty( $schedule_day ) ) { ?>
                                            <span><?php echo $schedule_day; ?></span>
										<?php } ?>
                                    </a>
                                </li>
							<?php } else { ?>
                                <li class="nav-item" role="presentation">
                                    <a title="<?php echo get_the_title( $postnav->ID ) ?>"
                                       href="<?php echo esc_attr( "#date" . $this->get_id() . $i ); ?>" role="tab"
                                       data-toggle="tab">
                                        <h3><?php echo get_the_title( $postnav->ID ) ?></h3>
										<?php if ( ! empty( exhibz_meta_option( $postnav->ID, 'schedule_day', '' ) ) ) { ?>
                                            <span><?php echo exhibz_meta_option( $postnav->ID, 'schedule_day', '' ); ?></span>
										<?php } ?>
                                    </a>
                                </li>
							<?php } ?>
							<?php $i ++;
						}
						wp_reset_postdata(); ?>
                    </ul>
                    <!-- Tab panes -->
                </div>
            </div>
            <!-- col end-->
        </div>
        <!-- row end-->
        <div class="row">
            <div class="col-lg-12">
                <div class="tab-content schedule-tabs">
					<?php
					$j = 1;
					foreach ( $posts as $post ) {
						setup_postdata( $post );
						$schedule_list = exhibz_meta_option( $post->ID, 'exhibz_schedule_pop_up', [] );
						?>
						<?php if ( $j == 1 ) { ?>
                            <div role="tabpanel" class="tab-pane active"
                                 id="<?php echo "date" . $this->get_id() . $j; ?>">
								<?php foreach ( $schedule_list as $key => $schedule ) { ?>
									<?php
                                    if ( $key == $schedule_limit ) {
										break;
									}
									$speaker = exhibz_meta_option( $schedule["speakers"], "exhibs_photo", '' );
									if ( ! empty( $speaker ) ) {
										$speaker_img_id = $speaker['id'];
									} else {
										$speaker_img_id = '';
									}
									$speaker_name = get_post( $schedule["speakers"] );
									?>
                                    <div class="schedule-listing">
                                        <div class="schedule-slot-time">
                                            <span> <?php echo esc_attr( $schedule["schedule_time"] ); ?> </span>

                                        </div>
                                        <div class="schedule-slot-info">
											<?php if ( $speaker ): ?>
                                                <a target="_blank"
                                                   href="<?php echo esc_url( get_the_permalink( $speaker_name->ID ) ); ?>">
													<?php echo wp_get_attachment_image( $speaker_img_id, array(
														'80',
														'80'
													), "", array( "class" => "schedule-slot-speakers" ) ); ?>
                                                </a>
											<?php endif; ?>
                                            <div class="schedule-slot-info-content">
                                                <p class="schedule-speaker speaker-1">
													<?php if ( $schedule["speakers"] != '' ): ?>
														<?php echo isset($speaker_name->post_title) ? esc_html( $speaker_name->post_title ) : ''; ?>
													<?php endif; ?>
                                                </p>

                                                <h3 class="schedule-slot-title">
													<?php echo esc_attr( $schedule["schedule_title"] ); ?>
                                                    <!-- <strong>@ Fredric Martinsson</strong> -->
                                                </h3>
                                                <p>
													<?php echo wp_kses_post( $schedule["schedule_note"] ); ?>
                                                </p>
                                            </div>
                                            <!--Info content end -->
                                        </div>
                                        <!-- Slot info end -->
                                    </div>
								<?php } // end loop schedule list ?>
                                <!--schedule-listing end -->
                            </div>
						<?php } else { //active ?>
                            <div role="tabpanel" class="tab-pane"
                                 id="<?php echo esc_attr( "date" . $this->get_id() . $j ); ?>">
								<?php foreach ( $schedule_list as $key => $schedule ) { ?>
									<?php
                                    if ( $key == $schedule_limit ) {
										break;
									}
									$speaker = exhibz_meta_option( $schedule["speakers"], "exhibs_photo", '' );
									if ( ! empty( $speaker ) ) {
										$speaker_img_id = $speaker['id'];
									} else {
										$speaker_img_id = '';
									}
									$speaker_name = get_post( $schedule["speakers"] );

									?>
                                    <div class="schedule-listing">
                                        <div class="schedule-slot-time">
                                            <span> <?php echo esc_attr( $schedule["schedule_time"] ); ?> </span>

                                        </div>
                                        <div class="schedule-slot-info">
											<?php if ( $speaker ): ?>
                                                <a target="_blank"
                                                   href="<?php echo esc_url( get_the_permalink( $speaker_name->ID ) ); ?>">
                                                    <img class="schedule-slot-speakers"
                                                         src="<?php echo wp_get_attachment_url( $speaker_img_id, 'thumbnail' ); ?>"
                                                         alt=" <?php echo esc_attr( $schedule["schedule_title"] ); ?>">
                                                </a>
											<?php endif; ?>
                                            <div class="schedule-slot-info-content">

                                                <p class="schedule-speaker speaker-1">
													<?php if ( $schedule["speakers"] != '' ): ?>
														<?php echo isset($speaker_name->post_title) ? esc_html( $speaker_name->post_title ) : ''; ?>
													<?php endif; ?>
                                                </p>

                                                <h3 class="schedule-slot-title">
													<?php echo esc_attr( $schedule["schedule_title"] ); ?>
                                                    <!-- <strong>@ Fredric Martinsson </strong> -->
                                                </h3>
                                                <p>
													<?php echo wp_kses_post( $schedule["schedule_note"] ); ?>
                                                </p>
                                            </div>
                                            <!--Info content end -->
                                        </div>
                                        <!-- Slot info end -->
                                    </div>
								<?php } // end loop schedule list ?>
                                <!--schedule-listing end -->
                            </div>
						<?php }//end else  ?>
						<?php
						$j ++;
					}
					wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- container end-->
</section>